/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.nio.file.Path;
import javax.inject.Inject;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.DefaultEvaluationContext;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.GraphConfigurationLoader;
import org.jboss.windup.engine.WindupConfiguration;
import org.jboss.windup.engine.WindupProcessor;
import org.jboss.windup.exec.DefaultRuleLifecycleListener;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;

public class WindupProcessorImpl
implements WindupProcessor {
    @Inject
    private GraphContextFactory factory;
    @Inject
    private GraphConfigurationLoader graphConfigurationLoader;

    public void execute() {
        this.execute(new WindupConfiguration());
    }

    public void execute(WindupConfiguration windupConfiguration) {
        Assert.notNull((Object)windupConfiguration, (String)"Windup configuration must not be null. (Call default execution if no configuration is required.)");
        GraphContext context = windupConfiguration.getGraphContext();
        if (context == null) {
            Path outputDirectory = windupConfiguration.getOutputDirectory();
            if (outputDirectory != null) {
                Path graphDir = outputDirectory.resolve("graph");
                context = this.factory.create(graphDir);
            } else {
                context = this.factory.create();
            }
        }
        if (null != windupConfiguration.getGraphListener()) {
            windupConfiguration.getGraphListener().postOpen(context);
        }
        Configuration rules = this.graphConfigurationLoader.loadConfiguration(context, windupConfiguration.getRuleProviderFilter());
        GraphRewrite event = new GraphRewrite(context);
        RuleSubset ruleSubset = RuleSubset.create((Configuration)rules);
        if (windupConfiguration.getProgressMonitor() != null) {
            ruleSubset.addLifecycleListener((RuleLifecycleListener)new DefaultRuleLifecycleListener(windupConfiguration.getProgressMonitor(), rules));
        }
        ruleSubset.perform((Rewrite)event, this.createEvaluationContext());
        if (null != windupConfiguration.getGraphListener()) {
            windupConfiguration.getGraphListener().preShutdown(context);
        }
    }

    private EvaluationContext createEvaluationContext() {
        DefaultEvaluationContext evaluationContext = new DefaultEvaluationContext();
        DefaultParameterValueStore values = new DefaultParameterValueStore();
        evaluationContext.put(ParameterValueStore.class, (Object)values);
        return evaluationContext;
    }
}

