/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.modules.javahandler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.javahandler.Initializer;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerException;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import com.tinkerpop.frames.util.ExceptionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;

class JavaFrameInitializer
implements FrameInitializer {
    private JavaHandlerModule module;
    private LoadingCache<Class<?>, List<InitializerMethod>> initializerCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, List<InitializerMethod>>(){

        public List<InitializerMethod> load(Class<?> frameClass) throws Exception {
            return JavaFrameInitializer.this.doLoad(frameClass);
        }
    });

    JavaFrameInitializer(JavaHandlerModule module) {
        this.module = module;
    }

    @Override
    public void initElement(Class<?> kind, FramedGraph<?> framedGraph, Element element) {
        Object framedElement = element instanceof Vertex ? framedGraph.frame((Vertex)element, kind) : framedGraph.frame((Edge)element, kind);
        try {
            for (InitializerMethod method : (List)this.initializerCache.get(kind)) {
                try {
                    method.execute(framedElement, framedGraph, element);
                }
                catch (IllegalArgumentException e) {
                    throw new JavaHandlerException("Problem calling Java handler", e);
                }
                catch (IllegalAccessException e) {
                    throw new JavaHandlerException("Problem calling Java handler", e);
                }
                catch (InvocationTargetException e) {
                    ExceptionUtils.sneakyThrow(e.getTargetException());
                }
            }
        }
        catch (ExecutionException e) {
            throw new JavaHandlerException("Problem calling Java handler", e);
        }
    }

    private List<InitializerMethod> doLoad(Class<?> kind) {
        ArrayList classes = new ArrayList();
        this.depthFirstClassSearch(classes, kind);
        Collections.reverse(classes);
        LinkedHashSet hierarchy = new LinkedHashSet(classes);
        ArrayList methods = Lists.newArrayList();
        for (Class clazz : hierarchy) {
            try {
                try {
                    Class<?> implKind = this.module.getHandlerClass(clazz);
                    for (Method method : implKind.getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(Initializer.class)) continue;
                        if (method.getParameterTypes().length != 0) {
                            throw new JavaHandlerException("Java handler initializer " + method + "cannot have parameters");
                        }
                        methods.add(new InitializerMethod(clazz, method));
                    }
                }
                catch (ClassNotFoundException e) {
                }
            }
            catch (IllegalArgumentException e) {
                throw new JavaHandlerException("Problem calling Java handler", e);
            }
        }
        return methods;
    }

    private void depthFirstClassSearch(List<Class<?>> initializers, Class<?> kind) {
        if (kind == null || kind == Object.class) {
            return;
        }
        initializers.add(kind);
        for (Class<?> i : kind.getInterfaces()) {
            this.depthFirstClassSearch(initializers, i);
        }
        this.depthFirstClassSearch(initializers, kind.getSuperclass());
    }

    private class InitializerMethod {
        private final Class<?> h;
        private final Method method;

        private InitializerMethod(Class<?> h, Method method) {
            this.h = h;
            this.method = method;
        }

        void execute(Object framedElement, FramedGraph<?> framedGraph, Element element) throws InvocationTargetException, IllegalAccessException {
            Object handler = JavaFrameInitializer.this.module.createHandler(framedElement, framedGraph, element, this.h, this.method);
            this.method.invoke(handler, new Object[0]);
        }
    }
}

