/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames;

import com.tinkerpop.blueprints.Vertex;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ClassUtilities {
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String REMOVE = "remove";
    private static final String ADD = "add";
    private static final String IS = "is";
    private static final String CAN = "can";

    public static Method getGetterMethodForSetter(Method setterMethod) {
        String propertyName = ClassUtilities.getBeanPropertyName(setterMethod);
        if (StringUtils.isBlank((String)propertyName)) {
            return null;
        }
        for (Method method : setterMethod.getDeclaringClass().getMethods()) {
            if (!ClassUtilities.isGetMethod(method) || !ClassUtilities.getBeanPropertyName(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    public static Method getSetterMethodForGetter(Method getterMethod) {
        String propertyName = ClassUtilities.getBeanPropertyName(getterMethod);
        if (StringUtils.isBlank((String)propertyName)) {
            return null;
        }
        for (Method method : getterMethod.getDeclaringClass().getMethods()) {
            if (!ClassUtilities.isSetMethod(method) || !ClassUtilities.getBeanPropertyName(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    public static String getBeanPropertyName(Method method) {
        boolean returnTypeIsBoolean;
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        boolean bl = returnTypeIsBoolean = returnType == Boolean.class || returnType == Boolean.TYPE;
        String propertyName = methodName.startsWith(GET) ? Introspector.decapitalize(StringUtils.removeStart((String)methodName, (String)GET)) : (methodName.startsWith(SET) ? Introspector.decapitalize(StringUtils.removeStart((String)methodName, (String)SET)) : (returnTypeIsBoolean && methodName.startsWith(IS) ? Introspector.decapitalize(StringUtils.removeStart((String)methodName, (String)IS)) : (returnTypeIsBoolean && methodName.startsWith(CAN) ? Introspector.decapitalize(StringUtils.removeStart((String)methodName, (String)CAN)) : null)));
        return propertyName;
    }

    public static boolean isGetMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return method.getName().startsWith(GET) || (returnType == Boolean.class || returnType == Boolean.TYPE) && (method.getName().startsWith(IS) || method.getName().startsWith(CAN));
    }

    public static boolean isSetMethod(Method method) {
        return method.getName().startsWith(SET);
    }

    public static boolean isRemoveMethod(Method method) {
        return method.getName().startsWith(REMOVE);
    }

    public static boolean acceptsIterable(Method method) {
        return 1 == method.getParameterTypes().length && Iterable.class.isAssignableFrom(method.getParameterTypes()[0]);
    }

    public static boolean returnsIterable(Method method) {
        return Iterable.class.isAssignableFrom(method.getReturnType());
    }

    public static boolean returnsVertex(Method method) {
        return Vertex.class.isAssignableFrom(method.getReturnType());
    }

    public static boolean returnsMap(Method method) {
        return Map.class.isAssignableFrom(method.getReturnType());
    }

    public static boolean isAddMethod(Method method) {
        return method.getName().startsWith(ADD);
    }

    public static Type getType(Type[] types, int pos) {
        if (pos >= types.length) {
            throw new RuntimeException("No type can be found at position " + pos);
        }
        return types[pos];
    }

    public static Class<?> getActualType(Type genericType, int pos) {
        if (genericType == null) {
            return null;
        }
        if (!ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            if (genericType instanceof TypeVariable) {
                genericType = ClassUtilities.getType(((TypeVariable)genericType).getBounds(), pos);
            } else if (genericType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)genericType;
                Type[] bounds = wildcardType.getLowerBounds();
                if (bounds.length == 0) {
                    bounds = wildcardType.getUpperBounds();
                }
                genericType = ClassUtilities.getType(bounds, pos);
            }
            Class<?> cls = (Class<?>)genericType;
            return cls.isArray() ? cls.getComponentType() : cls;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        Type t = ClassUtilities.getType(paramType.getActualTypeArguments(), pos);
        return t instanceof Class ? (Class<?>)t : ClassUtilities.getActualType(t, pos);
    }

    public static Class getGenericClass(Method method) {
        Type returnType = method.getGenericReturnType();
        return ClassUtilities.getActualType(returnType, 0);
    }
}

