/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import java.nio.file.Path;
import org.apache.commons.lang.RandomStringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.PathUtil;

public class ProjectService
extends GraphService<ProjectModel> {
    public static final String SHARED_LIBS_UNIQUE_ID = "<shared-libs>";
    public static final String SHARED_LIBS_APP_NAME = "Archives shared by multiple applications";
    public static final String SHARED_LIBS_FILENAME = "shared-libs";

    public ProjectService(GraphContext context) {
        super(context, ProjectModel.class);
    }

    public ProjectModel getByName(String name) {
        return (ProjectModel)this.getUnique(this.getTypedQuery().has("name", (Object)name));
    }

    public ProjectModel getByUniqueID(String id) {
        return (ProjectModel)this.getUnique(this.getTypedQuery().has("uniqueID", (Object)id));
    }

    public ProjectModel getOrCreateSharedLibsProject() {
        ProjectService service = new ProjectService(this.getGraphContext());
        ProjectModel sharedLibsProject = service.getByUniqueID(SHARED_LIBS_UNIQUE_ID);
        if (sharedLibsProject == null) {
            sharedLibsProject = (ProjectModel)service.create();
            sharedLibsProject.setName(SHARED_LIBS_APP_NAME);
            sharedLibsProject.setUniqueID(SHARED_LIBS_UNIQUE_ID);
            sharedLibsProject.setProjectType("VIRTUAL");
            Path archivesDirectory = WindupConfigurationService.getArchivesPath(this.getGraphContext());
            Path sharedLibsPath = archivesDirectory.resolve("shared-libs-" + RandomStringUtils.randomAlphabetic((int)6)).resolve(SHARED_LIBS_FILENAME);
            PathUtil.createDirectory((Path)sharedLibsPath, (String)"shared libs virtual app");
            FileModel sharedLibsFileModel = new FileService(this.getGraphContext()).createByFilePath(sharedLibsPath.toString());
            sharedLibsProject.setRootFileModel(sharedLibsFileModel);
            sharedLibsProject.addFileModel(sharedLibsFileModel);
            WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel(this.getGraphContext());
            configuration.addInputPath(sharedLibsFileModel);
        }
        return sharedLibsProject;
    }
}

