/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.EdgeFrame;
import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.typeresolvers.TypeResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.GraphModelScanner;
import org.jboss.windup.graph.TypeRegistry;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.WindupFrame;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;

public class GraphTypeManager
implements TypeResolver {
    private static final Logger LOG = Logger.getLogger(GraphTypeManager.class.getName());
    private GraphApiCompositeClassLoaderProvider graphApiCompositeClassLoaderProvider;
    private Furnace furnace;
    private Map<String, Class<? extends WindupFrame<?>>> registeredTypes;
    private TypeRegistry typeRegistry;
    private Map<String, Class<?>> classCache = new HashMap();

    public static String getTypeValue(Class<? extends WindupFrame> clazz) {
        TypeValue typeValueAnnotation = clazz.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            throw new IllegalArgumentException("Class " + clazz.getCanonicalName() + " lacks a @TypeValue annotation");
        }
        return typeValueAnnotation.value();
    }

    private static Set<String> getTypeProperties(Element abstractElement) {
        HashSet<String> results = new HashSet<String>();
        Iterator properties = null;
        if (abstractElement instanceof Vertex) {
            properties = ((Vertex)abstractElement).properties(new String[]{"w:winduptype"});
        } else if (abstractElement instanceof JanusGraphEdge) {
            Property typeProperty = abstractElement.property("w:winduptype");
            if (typeProperty.isPresent()) {
                List<String> all = Arrays.asList(((String)typeProperty.value()).split("\\|"));
                results.addAll(all);
                return results;
            }
        } else {
            properties = Collections.singleton(abstractElement.property("w:winduptype")).iterator();
        }
        if (properties == null) {
            return results;
        }
        properties.forEachRemaining(property -> {
            if (property.isPresent()) {
                results.add((String)property.value());
            }
        });
        return results;
    }

    public static boolean hasType(Class<? extends WindupVertexFrame> type, Vertex v) {
        TypeValue typeValueAnnotation = type.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            throw new IllegalArgumentException("Class " + type.getCanonicalName() + " lacks a @TypeValue annotation");
        }
        Set<String> vertexTypes = GraphTypeManager.getTypeProperties((Element)v);
        for (String typeValue : vertexTypes) {
            if (!typeValue.equals(typeValueAnnotation.value())) continue;
            return true;
        }
        return false;
    }

    private GraphApiCompositeClassLoaderProvider getGraphApiCompositeClassLoaderProvider() {
        if (this.graphApiCompositeClassLoaderProvider == null) {
            this.graphApiCompositeClassLoaderProvider = (GraphApiCompositeClassLoaderProvider)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(GraphApiCompositeClassLoaderProvider.class).get();
        }
        return this.graphApiCompositeClassLoaderProvider;
    }

    private Furnace getFurnace() {
        if (this.furnace == null) {
            this.furnace = SimpleContainer.getFurnace((ClassLoader)GraphContextFactory.class.getClassLoader());
        }
        return this.furnace;
    }

    private void initRegistry() {
        FurnaceClasspathScanner furnaceClasspathScanner = (FurnaceClasspathScanner)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(FurnaceClasspathScanner.class).get();
        this.registeredTypes = new HashMap();
        this.typeRegistry = new TypeRegistry();
        GraphModelScanner.loadFrames(furnaceClasspathScanner).forEach(this::addTypeToRegistry);
    }

    public Class<? extends WindupFrame> getTypeForDiscriminator(String discriminator) {
        return this.getRegisteredTypeMap().get(discriminator);
    }

    public Set<Class<? extends WindupFrame<?>>> getRegisteredTypes() {
        return Collections.unmodifiableSet(new HashSet(this.getRegisteredTypeMap().values()));
    }

    private synchronized Map<String, Class<? extends WindupFrame<?>>> getRegisteredTypeMap() {
        if (this.registeredTypes == null) {
            this.initRegistry();
        }
        return this.registeredTypes;
    }

    private synchronized TypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.initRegistry();
        }
        return this.typeRegistry;
    }

    private void addTypeToRegistry(Class<? extends WindupFrame<?>> frameType) {
        LOG.info(" Adding type to registry: " + frameType.getName());
        TypeValue typeValueAnnotation = frameType.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            String msg = String.format("@%s is missing on type %s", TypeValue.class.getSimpleName(), frameType.getName());
            LOG.warning(msg);
            return;
        }
        if (this.getRegisteredTypeMap().containsKey(typeValueAnnotation.value())) {
            throw new IllegalArgumentException("Type value for model '" + frameType.getCanonicalName() + "' is already registered with model " + this.getRegisteredTypeMap().get(typeValueAnnotation.value()).getName());
        }
        this.getRegisteredTypeMap().put(typeValueAnnotation.value(), frameType);
        this.getTypeRegistry().add(frameType);
    }

    public void removeTypeFromElement(Class<? extends WindupFrame<?>> kind, Element element) {
        TypeValue typeValueAnnotation = kind.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            return;
        }
        String typeValue = typeValueAnnotation.value();
        ArrayList<String> newTypes = new ArrayList<String>();
        for (String existingType : GraphTypeManager.getTypeProperties(element)) {
            if (existingType.equals(typeValue)) continue;
            newTypes.add(typeValue);
        }
        element.properties(new String[]{"w:winduptype"}).forEachRemaining(Property::remove);
        for (String newType : newTypes) {
            this.addProperty(element, "w:winduptype", newType);
        }
        this.addSuperclassType(kind, element);
    }

    private void addProperty(Element abstractElement, String propertyName, String propertyValue) {
        if (abstractElement instanceof Vertex) {
            ((Vertex)abstractElement).property(propertyName, (Object)propertyValue);
        } else if (abstractElement instanceof Edge) {
            this.addTokenProperty(abstractElement, propertyName, propertyValue);
        } else {
            Property property = abstractElement.property(propertyName);
            if (property == null) {
                abstractElement.property(propertyName, Collections.singletonList(propertyValue));
            } else {
                List existingList = (List)property.value();
                ArrayList<String> newList = new ArrayList<String>(existingList);
                newList.add(propertyValue);
                abstractElement.property(propertyName, newList);
            }
        }
    }

    private void addTokenProperty(Element el, String propertyName, String propertyValue) {
        Property val = el.property(propertyName);
        if (!val.isPresent()) {
            el.property(propertyName, (Object)propertyValue);
        } else {
            el.property(propertyName, (Object)((String)val.value() + "|" + propertyValue));
        }
    }

    public void addTypeToElement(Class<? extends WindupFrame<?>> kind, Element element) {
        TypeValue typeValueAnnotation = kind.getAnnotation(TypeValue.class);
        if (typeValueAnnotation == null) {
            return;
        }
        String typeValue = typeValueAnnotation.value();
        Set<String> types = GraphTypeManager.getTypeProperties(element);
        for (String typePropertyValue : types) {
            if (!typePropertyValue.equals(typeValue)) continue;
            return;
        }
        this.addProperty(element, "w:winduptype", typeValue);
        this.addSuperclassType(kind, element);
    }

    private void addSuperclassType(Class<? extends WindupFrame<?>> kind, Element element) {
        for (Class<?> superInterface : kind.getInterfaces()) {
            if (!WindupFrame.class.isAssignableFrom(superInterface)) continue;
            this.addTypeToElement(superInterface, element);
        }
    }

    public <T> Class<T> resolve(Element e, Class<T> defaultType) {
        Set<String> valuesAll = GraphTypeManager.getTypeProperties(e);
        if (valuesAll == null || valuesAll.isEmpty()) {
            return defaultType;
        }
        ArrayList resultClasses = new ArrayList();
        resultClasses.add(defaultType);
        for (String value : valuesAll) {
            Class<?> type = this.getTypeRegistry().getType(value);
            if (type == null) continue;
            ListIterator previouslyAddedIterator = resultClasses.listIterator();
            boolean shouldAdd = true;
            while (previouslyAddedIterator.hasNext()) {
                Class previouslyAdded = (Class)previouslyAddedIterator.next();
                if (previouslyAdded.isAssignableFrom(type)) {
                    previouslyAddedIterator.remove();
                    continue;
                }
                if (!type.isAssignableFrom(previouslyAdded)) continue;
                shouldAdd = false;
            }
            if (!shouldAdd) continue;
            resultClasses.add(type);
        }
        if (!resultClasses.isEmpty()) {
            return this.getClass(resultClasses);
        }
        return defaultType;
    }

    private Class<?> getClass(List<Class<?>> interfaces) {
        List interfaceNames = interfaces.stream().map(Class::getCanonicalName).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        String key = interfaceNames.toString();
        Class result = this.classCache.get(key);
        if (result == null) {
            result = new ByteBuddy().makeInterface().implement(interfaces).make().load(this.getGraphApiCompositeClassLoaderProvider().getCompositeClassLoader()).getLoaded();
            this.classCache.put(key, result);
        }
        return result;
    }

    public Class<?> resolve(Element element) {
        return this.resolve(element, WindupFrame.class);
    }

    public void init(Element element, Class<?> kind) {
        if (VertexFrame.class.isAssignableFrom(kind) || EdgeFrame.class.isAssignableFrom(kind)) {
            this.addTypeToElement(kind, element);
        }
    }

    public void deinit(Element element) {
        element.properties(new String[]{"w:winduptype"}).forEachRemaining(Property::remove);
    }

    public <P extends Element, T extends Element> GraphTraversal<P, T> hasType(GraphTraversal<P, T> traverser, Class<?> type) {
        String typeValue = GraphTypeManager.getTypeValue(type);
        return traverser.has("w:winduptype", P.eq((Object)typeValue));
    }

    public <P extends Element, T extends Element> GraphTraversal<P, T> hasNotType(GraphTraversal<P, T> traverser, Class<?> type) {
        final String typeValue = GraphTypeManager.getTypeValue(type);
        return traverser.filter(new Predicate<Traverser<T>>(){

            @Override
            public boolean test(Traverser<T> toCheck) {
                Property property = ((Element)toCheck.get()).property("w:winduptype");
                if (!property.isPresent()) {
                    return true;
                }
                String resolvedType = (String)property.value();
                return !typeValue.contains(resolvedType);
            }
        });
    }
}

