/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import com.syncleus.ferma.FramedGraph;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;

public class ArchiveService
extends GraphService<ArchiveModel> {
    public ArchiveService(GraphContext context) {
        super(context, ArchiveModel.class);
    }

    public Iterable<ArchiveModel> findBySHA1(String sha1) {
        List query = this.getGraphContext().getGraph().traversal().V(new Object[0]).property((Object)"sha1Hash", (Object)sha1, new Object[0]).property((Object)"w:winduptype", (Object)Text.CONTAINS, new Object[]{"ArchiveModel"}).toList();
        return new FramedVertexIterable<ArchiveModel>((FramedGraph)this.getGraphContext().getFramed(), query, ArchiveModel.class);
    }

    public FileModel getChildFile(ArchiveModel archiveModel, String filePath) {
        filePath = FilenameUtils.separatorsToUnix((String)filePath);
        StringTokenizer stk = new StringTokenizer(filePath, "/");
        FileModel currentFileModel = archiveModel;
        while (stk.hasMoreTokens() && currentFileModel != null) {
            String pathElement = stk.nextToken();
            currentFileModel = this.findFileModel(currentFileModel, pathElement);
        }
        return currentFileModel;
    }

    private FileModel findFileModel(FileModel fm, String pathElement) {
        FileModel result = null;
        for (FileModel child : fm.getFilesInDirectory()) {
            if (!child.getFileName().equals(pathElement)) continue;
            result = child;
            break;
        }
        return result;
    }
}

