/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.WrappedFramedGraph;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.janusgraph.core.JanusGraph;
import org.jboss.windup.graph.DefaultValueInitializer;
import org.jboss.windup.graph.JavaHandler;

public interface WindupFrame<T extends Element>
extends ElementFrame {
    public static final String TYPE_PROP = "w:winduptype";

    @JavaHandler(handler=Impl.class)
    public String toString();

    @JavaHandler(handler=Impl.class)
    public void init();

    @JavaHandler(handler=Impl.class)
    public boolean equals(Object var1);

    default public WrappedFramedGraph<JanusGraph> getWrappedGraph() {
        return (WrappedFramedGraph)this.getGraph();
    }

    default public String toPrettyString() {
        Element v = this.getElement();
        StringBuilder result = new StringBuilder();
        result.append("[").append(v.toString()).append("=");
        result.append("{");
        boolean hasSome = false;
        for (String propKey : v.keys()) {
            hasSome = true;
            Iterator propVal = v.properties(new String[]{propKey});
            ArrayList propValues = new ArrayList();
            propVal.forEachRemaining(prop -> propValues.add(prop.value()));
            if (propValues.size() == 1) {
                result.append(propKey).append(": ").append(propValues.get(0));
            } else {
                result.append(propKey).append(": ").append(propValues);
            }
            result.append(", ");
        }
        if (hasSome) {
            result.delete(result.length() - 2, result.length());
        }
        result.append("}]");
        return result.toString();
    }

    public static class Impl {
        public String toString(ElementFrame frame) {
            if (frame instanceof WindupFrame) {
                return ((WindupFrame)frame).toPrettyString();
            }
            return frame.toString();
        }

        public void init(ElementFrame frame) {
            new DefaultValueInitializer().initalize(frame);
        }

        public boolean equals(ElementFrame thiz, Object o) {
            Element element;
            if (o instanceof Element) {
                element = (Element)o;
            } else if (o instanceof ElementFrame) {
                element = ((ElementFrame)o).getElement();
            } else {
                return false;
            }
            return thiz.getElement().equals(element);
        }
    }
}

