/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.IndexType;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.Indexes;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.frames.FrameBooleanDefaultValue;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.HasApplications;
import org.jboss.windup.graph.model.HasProject;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.resource.ResourceModel;

@TypeValue(value="FileModel")
public interface FileModel
extends ResourceModel,
HasApplications,
HasProject {
    public static final String TYPE = "FileModel";
    public static final String PARENT_FILE = "parentFile";
    public static final String SHA1_HASH = "sha1Hash";
    public static final String MD5_HASH = "md5Hash";
    public static final String FILE_NAME = "fileName";
    public static final String FILE_PATH = "filePath";
    public static final String PRETTY_PATH = "cachedPrettyPath";
    public static final String IS_DIRECTORY = "isDirectory";
    public static final String WINDUP_GENERATED = "windupGenerated";
    public static final String PARSE_ERROR = "parseError";
    public static final String ON_PARSE_ERROR = "onParseError";
    public static final String SIZE = "size";
    public static final String DIRECTORY_SIZE = "directorySize";

    @Property(value="fileName")
    public String getFileName();

    @Indexes(value={@Indexed, @Indexed(value=IndexType.SEARCH, name="filenamesearchindex")})
    @Property(value="fileName")
    public void setFileName(String var1);

    @Indexed
    @Property(value="filePath")
    public String getFilePath();

    default public void setFilePath(String filePath) {
        File file = new File(filePath);
        Vertex vertex = this.getElement();
        Long size = new Long(0L);
        if (!file.isDirectory()) {
            size = file.length();
        }
        this.getWrappedGraph().getRawTraversal().V(new Object[]{vertex}).property((Object)IS_DIRECTORY, (Object)file.isDirectory(), new Object[0]).property((Object)FILE_PATH, (Object)file.getAbsolutePath(), new Object[0]).property((Object)FILE_NAME, (Object)file.getName(), new Object[0]).property((Object)SIZE, (Object)size, new Object[0]).iterate();
    }

    @Property(value="cachedPrettyPath")
    public String getCachedPrettyPath();

    @Property(value="cachedPrettyPath")
    public void setCachedPrettyPath(String var1);

    @Property(value="isDirectory")
    public boolean isDirectory();

    @Property(value="md5Hash")
    public String getMD5Hash();

    @Property(value="md5Hash")
    public void setMD5Hash(String var1);

    @Property(value="sha1Hash")
    @Indexed
    public String getSHA1Hash();

    @Property(value="sha1Hash")
    public void setSHA1Hash(String var1);

    @Property(value="parseError")
    public String getParseError();

    @Property(value="parseError")
    public void setParseError(String var1);

    @Property(value="onParseError")
    public OnParseError getOnParseError();

    @Property(value="onParseError")
    public void setOnParseError(OnParseError var1);

    @Property(value="size")
    public Long getSize();

    @Property(value="size")
    public void setSize(Long var1);

    @Property(value="directorySize")
    public Long getDirectorySize();

    @Property(value="directorySize")
    public void setDirectorySize(Long var1);

    @Adjacency(label="parentFile", direction=Direction.OUT)
    public FileModel getParentFileInternal();

    default public FileModel getParentFile() {
        try {
            return this.getParentFileInternal();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Adjacency(label="parentFile", direction=Direction.OUT)
    public void setParentFile(FileModel var1);

    @Adjacency(label="parentFile", direction=Direction.IN)
    public List<FileModel> getFilesInDirectory();

    @Adjacency(label="parentFile", direction=Direction.IN)
    public void addFileToDirectory(FileModel var1);

    @Adjacency(label="projectModelToFile", direction=Direction.IN)
    public ProjectModel getProjectModelNotNullSafe();

    @Override
    default public ProjectModel getProjectModel() {
        try {
            return this.getProjectModelNotNullSafe();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    default public File asFile() throws RuntimeException {
        if (this.getFilePath() == null) {
            return null;
        }
        return new File(this.getFilePath());
    }

    @Override
    default public InputStream asInputStream() throws RuntimeException {
        try {
            if (this.getFilePath() == null) {
                return null;
            }
            File file = new File(this.getFilePath());
            return new FileInputStream(file);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception reading resource.", e);
        }
    }

    default public String getPrettyPath() {
        String filename = this.getFileName();
        Object result = this.getParentFile() == null ? filename : this.getParentFile().getPrettyPath() + "/" + filename;
        return result;
    }

    default public ArchiveModel getArchive() {
        if (this instanceof ArchiveModel) {
            return (ArchiveModel)this;
        }
        if (this.getParentFile() == null) {
            return null;
        }
        return this.getParentFile().getArchive();
    }

    default public String getPrettyPathWithinProject() {
        Object result;
        ProjectModel projectModel = this.getProjectModel();
        if (projectModel == null) {
            result = this.getPrettyPath();
        } else if (projectModel.getRootFileModel().getFilePath().equals(this.getFilePath())) {
            result = "";
        } else {
            String parentPrettyPath;
            String filename = this.getFileName();
            result = this.getParentFile() == null ? filename : (StringUtils.isEmpty((CharSequence)(parentPrettyPath = this.getParentFile().getPrettyPathWithinProject())) ? filename : parentPrettyPath + "/" + filename);
        }
        return result;
    }

    default public String getPrettyPathWithinProject(boolean useFQNForClasses) {
        return this.getPrettyPathWithinProject();
    }

    default public ProjectModel getApplication() {
        ProjectModel projectModel = this.getProjectModel();
        if (projectModel == null) {
            return null;
        }
        return projectModel.getRootProjectModel();
    }

    @Override
    default public List<ProjectModel> getApplications() {
        return this.getProjectModel().getApplications();
    }

    @Property(value="windupGenerated")
    public Boolean isWindupGenerated();

    @FrameBooleanDefaultValue(value=false)
    @Property(value="windupGenerated")
    public void setWindupGenerated(boolean var1);

    @Override
    default public boolean belongsToProject(ProjectModel projectModel) {
        ProjectModel argCanonicalProjectModel = this.getCanonicalProjectModel(projectModel);
        for (ProjectModel rootProjectModel : this.getApplications()) {
            if (!rootProjectModel.equals(argCanonicalProjectModel)) continue;
            return true;
        }
        return false;
    }

    default public Long retrieveSize() {
        File file = this.asFile();
        if (file == null || !file.isFile() || !file.exists()) {
            return null;
        }
        return file.length();
    }

    public static enum OnParseError {
        IGNORE,
        WARN;


        OnParseError fromName(String name) {
            return (OnParseError)EnumUtils.getEnum(OnParseError.class, (String)StringUtils.upperCase((String)name));
        }
    }
}

