/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import com.syncleus.ferma.FramedGraph;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.TitanUtil;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.util.ExecutionStatistics;

public class FileService
extends GraphService<FileModel> {
    public FileService(GraphContext context) {
        super(context, FileModel.class);
    }

    public FileModel createByFilePath(String filePath) {
        return this.createByFilePath(null, filePath);
    }

    public FileModel createByFilePath(FileModel parentFile, String filePath) {
        ExecutionStatistics.get().begin("FileService.createByFilePath(parentFile, filePath)");
        String absolutePath = Paths.get(filePath, new String[0]).normalize().toAbsolutePath().toString();
        FileModel entry = this.findByPath(absolutePath);
        if (entry == null) {
            entry = (FileModel)this.create();
            entry.setFilePath(absolutePath);
            entry.setParentFile(parentFile);
        }
        if (entry.getParentFile() == null && parentFile != null) {
            entry.setParentFile(parentFile);
        }
        ExecutionStatistics.get().end("FileService.createByFilePath(parentFile, filePath)");
        return entry;
    }

    public FileModel findByPath(String filePath) {
        filePath = Paths.get(filePath, new String[0]).toAbsolutePath().toString();
        return (FileModel)this.getUniqueByProperty("filePath", filePath);
    }

    public Iterable<FileModel> findByFilenameRegex(String filenameRegex) {
        filenameRegex = TitanUtil.titanifyRegex(filenameRegex);
        List vertices = this.getGraphContext().getGraph().traversal().V(new Object[0]).has("fileName", (P)Text.textRegex((Object)filenameRegex)).filter(traversal -> {
            Iterator typeIterator = ((Vertex)traversal.get()).properties(new String[]{"w:winduptype"});
            while (typeIterator.hasNext()) {
                if (!"FileModel".equals(((VertexProperty)typeIterator.next()).value())) continue;
                return true;
            }
            return false;
        }).toList();
        return new FramedVertexIterable<FileModel>((FramedGraph)this.getGraphContext().getFramed(), vertices, FileModel.class);
    }

    public List<FileModel> findArchiveEntryWithExtension(String ... values) {
        String regex;
        if (values.length == 0) {
            return Collections.emptyList();
        }
        if (values.length == 1) {
            regex = ".+\\." + values[0] + "$";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            for (String value : values) {
                builder.append("|");
                builder.append(value);
            }
            builder.append(")\\b");
            regex = ".+\\." + builder.toString() + "$";
        }
        return this.getGraphContext().getQuery(FileModel.class).traverse(g -> g.has("filePath", (P)Text.textRegex((Object)regex))).toList(FileModel.class);
    }
}

