/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ApplicationModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.util.PathUtil;

public class ProjectService
extends GraphService<ProjectModel> {
    public static final String SHARED_LIBS_UNIQUE_ID = "<shared-libs>";
    public static final String SHARED_LIBS_APP_NAME = "Archives shared by multiple applications";
    public static final String SHARED_LIBS_FILENAME = "shared-libs";

    public ProjectService(GraphContext context) {
        super(context, ProjectModel.class);
    }

    public ProjectModel getByName(String name) {
        return (ProjectModel)this.getUnique((Traversal<?, ?>)this.getQuery().getRawTraversal().has("name", (Object)name));
    }

    public ProjectModel getByUniqueID(String id) {
        return (ProjectModel)this.getUnique((Traversal<?, ?>)this.getQuery().getRawTraversal().has("uniqueID", (Object)id));
    }

    public ProjectModel getOrCreateSharedLibsProject() {
        ProjectService service = new ProjectService(this.getGraphContext());
        ProjectModel sharedLibsProject = service.getByUniqueID(SHARED_LIBS_UNIQUE_ID);
        if (sharedLibsProject == null) {
            sharedLibsProject = (ProjectModel)service.create();
            sharedLibsProject.setName(SHARED_LIBS_APP_NAME);
            sharedLibsProject.setUniqueID(SHARED_LIBS_UNIQUE_ID);
            sharedLibsProject.setProjectType("VIRTUAL");
            Path archivesDirectory = WindupConfigurationService.getArchivesPath(this.getGraphContext());
            Path sharedLibsPath = archivesDirectory.resolve("shared-libs-" + RandomStringUtils.randomAlphabetic((int)6)).resolve(SHARED_LIBS_FILENAME);
            PathUtil.createDirectory((Path)sharedLibsPath, (String)"shared libs virtual app");
            FileModel sharedLibsFileModel = new FileService(this.getGraphContext()).createByFilePath(sharedLibsPath.toString());
            ApplicationModel applicationModel = GraphService.addTypeToModel(this.getGraphContext(), sharedLibsFileModel, ApplicationModel.class);
            applicationModel.setApplicationName(SHARED_LIBS_FILENAME);
            sharedLibsProject.setRootFileModel(sharedLibsFileModel);
            sharedLibsProject.addFileModel(sharedLibsFileModel);
            WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel(this.getGraphContext());
            configuration.addInputPath(sharedLibsFileModel);
        }
        return sharedLibsProject;
    }

    public Map<ProjectModel, ProjectModel> getProjectToRootProjectMap() {
        HashMap<ProjectModel, ProjectModel> projectModels = new HashMap<ProjectModel, ProjectModel>();
        for (FileModel inputPath : WindupConfigurationService.getConfigurationModel(this.getGraphContext()).getInputPaths()) {
            ProjectModel rootProjectModel = inputPath.getProjectModel();
            if (rootProjectModel == null) continue;
            ProjectModelTraversal traversal = new ProjectModelTraversal(rootProjectModel);
            traversal.getAllProjects(true).forEach(subProject -> projectModels.put((ProjectModel)subProject, rootProjectModel));
        }
        return projectModels;
    }

    public Set<ProjectModel> getFilteredProjectModels(Collection<String> selectedPaths) {
        HashSet<ProjectModel> projectModels = new HashSet<ProjectModel>();
        if (selectedPaths.isEmpty()) {
            return projectModels;
        }
        for (FileModel inputPath : WindupConfigurationService.getConfigurationModel(this.getGraphContext()).getInputPaths()) {
            ProjectModel rootProjectModel;
            String filePath = inputPath.getFilePath();
            if (!selectedPaths.contains(filePath) || (rootProjectModel = inputPath.getProjectModel()) == null) continue;
            ProjectModelTraversal traversal = new ProjectModelTraversal(rootProjectModel);
            projectModels.addAll(traversal.getAllProjects(true));
        }
        return projectModels;
    }

    public Set<ProjectModel> getRootProjectModels() {
        List<FileModel> fileModelIterable = WindupConfigurationService.getConfigurationModel(this.getGraphContext()).getInputPaths();
        return StreamSupport.stream(fileModelIterable.spliterator(), false).map(FileModel::getProjectModel).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

