/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.GraphContextImpl;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;

public class GraphContextFactoryImpl
implements GraphContextFactory {
    private static Logger LOG = Logging.get(GraphContextFactoryImpl.class);
    private GraphApiCompositeClassLoaderProvider graphApiCompositeClassLoaderProvider;
    private Furnace furnace;
    private GraphTypeManager graphTypeManager;
    private final Map<String, GraphContext> graphMap = new HashMap<String, GraphContext>();

    private Furnace getFurnace() {
        if (this.furnace == null) {
            this.furnace = SimpleContainer.getFurnace((ClassLoader)GraphContextFactory.class.getClassLoader());
        }
        return this.furnace;
    }

    private GraphApiCompositeClassLoaderProvider getGraphApiCompositeClassLoaderProvider() {
        if (this.graphApiCompositeClassLoaderProvider == null) {
            this.graphApiCompositeClassLoaderProvider = (GraphApiCompositeClassLoaderProvider)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(GraphApiCompositeClassLoaderProvider.class).get();
        }
        return this.graphApiCompositeClassLoaderProvider;
    }

    private GraphTypeManager getGraphTypeManager() {
        if (this.graphTypeManager == null) {
            this.graphTypeManager = (GraphTypeManager)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(GraphTypeManager.class).get();
        }
        return this.graphTypeManager;
    }

    public GraphContext create(boolean enableListeners) {
        return (GraphContext)ExecutionStatistics.performBenchmarked((String)(GraphContextFactory.class.getName() + ".create(Path)"), () -> {
            GraphContextImpl graphContext = new GraphContextImpl(this.getFurnace(), this.getGraphTypeManager(), this.getGraphApiCompositeClassLoaderProvider(), this.getTempGraphDirectory()).create(enableListeners);
            this.graphMap.put(graphContext.getGraphDirectory().toString(), graphContext);
            return graphContext;
        });
    }

    public GraphContext create(Path graphDir, boolean enableListeners) {
        return (GraphContext)ExecutionStatistics.performBenchmarked((String)(GraphContextFactory.class.getName() + ".create(Path)"), () -> {
            GraphContextImpl graphContext = new GraphContextImpl(this.getFurnace(), this.getGraphTypeManager(), this.getGraphApiCompositeClassLoaderProvider(), graphDir).create(enableListeners);
            this.graphMap.put(graphContext.getGraphDirectory().toString(), graphContext);
            return graphContext;
        });
    }

    public GraphContext load(Path graphDir) {
        GraphContextImpl graphContext = new GraphContextImpl(this.getFurnace(), this.getGraphTypeManager(), this.getGraphApiCompositeClassLoaderProvider(), graphDir).load();
        this.graphMap.put(graphContext.getGraphDirectory().toString(), graphContext);
        return graphContext;
    }

    private Path getTempGraphDirectory() {
        return new File(FileUtils.getTempDirectory(), "windupgraph_" + RandomStringUtils.randomAlphanumeric((int)6)).toPath();
    }

    public void closeAll() {
        try {
            LOG.info("Checking for any previously opened graphs...");
            LOG.info("Already opened: " + this.graphMap.keySet());
            for (String graphName : this.graphMap.keySet()) {
                LOG.info("Still open graph: " + graphName);
                GraphContext graphContext = this.graphMap.get(graphName);
                graphContext.close();
                LOG.info("Closed graph: " + graphName);
            }
            this.graphMap.clear();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Failed at closing previously opened graphs due to: " + t.getMessage(), t);
        }
    }
}

