/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.sleepycat.je.LockMode;
import com.syncleus.ferma.ClassInitializer;
import com.syncleus.ferma.DelegatingFramedGraph;
import com.syncleus.ferma.ReflectionCache;
import com.syncleus.ferma.Traversable;
import com.syncleus.ferma.WrappedFramedGraph;
import com.syncleus.ferma.framefactories.FrameFactory;
import com.syncleus.ferma.framefactories.annotation.MethodHandler;
import com.syncleus.ferma.typeresolvers.TypeResolver;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Annotations;
import org.jboss.windup.graph.AnnotationFrameFactory;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphListener;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.Indexes;
import org.jboss.windup.graph.MapInAdjacentPropertiesHandler;
import org.jboss.windup.graph.MapInAdjacentVerticesHandler;
import org.jboss.windup.graph.MapInPropertiesHandler;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.SetInPropertiesHandler;
import org.jboss.windup.graph.WindupAdjacencyMethodHandler;
import org.jboss.windup.graph.WindupPropertyMethodHandler;
import org.jboss.windup.graph.javahandler.JavaHandlerHandler;
import org.jboss.windup.graph.listeners.AfterGraphInitializationListener;
import org.jboss.windup.graph.listeners.BeforeGraphCloseListener;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;

public class GraphContextImpl
implements GraphContext {
    private static final Logger LOG = Logger.getLogger(GraphContextImpl.class.getName());
    private final Furnace furnace;
    private final GraphTypeManager graphTypeManager;
    private final Path graphDir;
    private final GraphApiCompositeClassLoaderProvider classLoaderProvider;
    private final Map<String, BeforeGraphCloseListener> beforeGraphCloseListenerBuffer = new HashMap<String, BeforeGraphCloseListener>();
    private final List<GraphListener> graphListeners = new ArrayList<GraphListener>();
    private Map<String, Object> configurationOptions;
    private JanusGraph graph;
    private WrappedFramedGraph<JanusGraph> framed;
    private Configuration conf;
    private static final GraphContextMutationListener mutationListener = new GraphContextMutationListener();

    public GraphContextImpl(Furnace furnace, GraphTypeManager typeManager, GraphApiCompositeClassLoaderProvider classLoaderProvider, Path graphDir) {
        this.furnace = furnace;
        this.graphTypeManager = typeManager;
        this.classLoaderProvider = classLoaderProvider;
        this.graphDir = graphDir;
    }

    public void registerGraphListener(GraphListener listener) {
        this.graphListeners.add(listener);
    }

    public GraphContextImpl create(boolean enableListeners) {
        FileUtils.deleteQuietly((File)this.graphDir.toFile());
        JanusGraph janusGraph = this.initializeJanusGraph(true, enableListeners);
        this.initializeJanusIndexes(janusGraph);
        this.createFramed(janusGraph);
        this.fireListeners();
        return this;
    }

    public GraphContextImpl load() {
        JanusGraph janusGraph = this.initializeJanusGraph(false, false);
        this.createFramed(janusGraph);
        this.fireListeners();
        return this;
    }

    private void fireListeners() {
        Imported afterInitializationListeners = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(AfterGraphInitializationListener.class);
        HashMap<String, Object> confProps = new HashMap<String, Object>();
        Iterator keyIter = this.conf.getKeys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            confProps.put(key, this.conf.getProperty(key));
        }
        if (!afterInitializationListeners.isUnsatisfied()) {
            for (AfterGraphInitializationListener listener : afterInitializationListeners) {
                listener.afterGraphStarted(confProps, (GraphContext)this);
                if (!(listener instanceof BeforeGraphCloseListener)) continue;
                this.beforeGraphCloseListenerBuffer.put(listener.getClass().toString(), (BeforeGraphCloseListener)listener);
            }
        }
    }

    private void createFramed(JanusGraph janusGraph) {
        this.graph = janusGraph;
        ClassLoader compositeClassLoader = this.classLoaderProvider.getCompositeClassLoader();
        ReflectionCache reflections = new ReflectionCache();
        HashSet<MethodHandler> handlers = new HashSet<MethodHandler>();
        handlers.add(new MapInPropertiesHandler());
        handlers.add(new MapInAdjacentPropertiesHandler());
        handlers.add(new MapInAdjacentVerticesHandler());
        handlers.add(new SetInPropertiesHandler());
        handlers.add(new JavaHandlerHandler());
        handlers.add((MethodHandler)new WindupPropertyMethodHandler());
        handlers.add((MethodHandler)new WindupAdjacencyMethodHandler());
        AnnotationFrameFactory frameFactory = new AnnotationFrameFactory(compositeClassLoader, reflections, handlers);
        this.framed = new DelegatingFramedGraph<JanusGraph>(janusGraph, (FrameFactory)frameFactory, (TypeResolver)this.graphTypeManager){

            public <T> T addFramedVertex(ClassInitializer<T> initializer, Object ... keyValues) {
                Object framedVertex;
                JanusGraphVertex vertex;
                if (keyValues != null) {
                    vertex = ((JanusGraph)this.getBaseGraph()).addVertex(keyValues);
                    framedVertex = this.frameNewElement((Element)vertex, initializer);
                } else {
                    vertex = ((JanusGraph)this.getBaseGraph()).addVertex(new Object[0]);
                    framedVertex = this.frameNewElement((Element)vertex, initializer);
                }
                mutationListener.vertexAdded((Vertex)vertex);
                return (T)framedVertex;
            }

            public <T> T addFramedVertexExplicit(ClassInitializer<T> initializer) {
                JanusGraphVertex vertex = ((JanusGraph)this.getBaseGraph()).addVertex(new Object[0]);
                Object framedVertex = this.frameNewElementExplicit((Element)vertex, initializer);
                mutationListener.vertexAdded((Vertex)vertex);
                return (T)framedVertex;
            }
        };
    }

    private List<Indexed> getIndexAnnotations(Method method) {
        Indexes indexes;
        ArrayList<Indexed> results = new ArrayList<Indexed>();
        Indexed index = method.getAnnotation(Indexed.class);
        if (index != null) {
            results.add(index);
        }
        if ((indexes = method.getAnnotation(Indexes.class)) != null) {
            Collections.addAll(results, indexes.value());
        }
        return results;
    }

    private void initializeJanusIndexes(JanusGraph janusGraph) {
        PropertyKey propKey;
        Class<?> dataType;
        HashMap<String, IndexData> defaultIndexKeys = new HashMap<String, IndexData>();
        HashMap<String, IndexData> searchIndexKeys = new HashMap<String, IndexData>();
        HashMap<String, IndexData> listIndexKeys = new HashMap<String, IndexData>();
        Set modelTypes = this.graphTypeManager.getRegisteredTypes();
        for (Iterator type : modelTypes) {
            for (Method method : ((Class)((Object)type)).getDeclaredMethods()) {
                List<Indexed> annotations = this.getIndexAnnotations(method);
                for (Indexed index : annotations) {
                    Property property = (Property)Annotations.getAnnotation((Method)method, Property.class);
                    if (property == null) continue;
                    Class dataType2 = index.dataType();
                    switch (index.value()) {
                        case DEFAULT: {
                            defaultIndexKeys.put(property.value(), new IndexData(property.value(), index.name(), dataType2));
                            break;
                        }
                        case SEARCH: {
                            searchIndexKeys.put(property.value(), new IndexData(property.value(), index.name(), dataType2));
                            break;
                        }
                        case LIST: {
                            listIndexKeys.put(property.value(), new IndexData(property.value(), index.name(), dataType2));
                            break;
                        }
                    }
                }
            }
        }
        listIndexKeys.put("w:winduptype", new IndexData("w:winduptype", "", String.class));
        LOG.info("Detected and initialized [" + defaultIndexKeys.size() + "] default indexes: " + defaultIndexKeys);
        LOG.info("Detected and initialized [" + searchIndexKeys.size() + "] search indexes: " + searchIndexKeys);
        LOG.info("Detected and initialized [" + listIndexKeys.size() + "] list indexes: " + listIndexKeys);
        JanusGraphManagement janusGraphManagement = janusGraph.openManagement();
        for (Map.Entry entry : defaultIndexKeys.entrySet()) {
            String key = (String)entry.getKey();
            IndexData indexData = (IndexData)entry.getValue();
            dataType = indexData.type;
            propKey = this.getOrCreatePropertyKey(janusGraphManagement, key, dataType, Cardinality.SINGLE);
            janusGraphManagement.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        for (Map.Entry entry : searchIndexKeys.entrySet()) {
            String key = (String)entry.getKey();
            IndexData indexData = (IndexData)entry.getValue();
            dataType = indexData.type;
            if (dataType == String.class) {
                propKey = this.getOrCreatePropertyKey(janusGraphManagement, key, String.class, Cardinality.SINGLE);
                janusGraphManagement.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex("search");
                continue;
            }
            propKey = this.getOrCreatePropertyKey(janusGraphManagement, key, dataType, Cardinality.SINGLE);
            janusGraphManagement.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey).buildMixedIndex("search");
        }
        for (Map.Entry entry : listIndexKeys.entrySet()) {
            String key = (String)entry.getKey();
            IndexData indexData = (IndexData)entry.getValue();
            dataType = indexData.type;
            propKey = this.getOrCreatePropertyKey(janusGraphManagement, key, dataType, Cardinality.LIST);
            janusGraphManagement.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        String indexName = "edge-typevalue";
        PropertyKey propKey2 = this.getOrCreatePropertyKey(janusGraphManagement, "w:winduptype", String.class, Cardinality.LIST);
        janusGraphManagement.buildIndex(indexName, Edge.class).addKey(propKey2).buildCompositeIndex();
        janusGraphManagement.commit();
    }

    private PropertyKey getOrCreatePropertyKey(JanusGraphManagement janusGraphManagement, String key, Class<?> dataType, Cardinality cardinality) {
        PropertyKey propertyKey = janusGraphManagement.getPropertyKey(key);
        if (propertyKey == null) {
            propertyKey = janusGraphManagement.makePropertyKey(key).dataType(dataType).cardinality(cardinality).make();
        }
        return propertyKey;
    }

    private JanusGraph initializeJanusGraph(boolean createMode, boolean enableListeners) {
        LOG.fine("Initializing graph.");
        Path lucene = this.graphDir.resolve("graphsearch");
        Path berkeley = this.graphDir.resolve("titangraph");
        this.conf = new BaseConfiguration();
        this.conf.setProperty("graph.unique-instance-id", (Object)("windup_" + System.nanoTime() + "_" + RandomStringUtils.randomAlphabetic((int)6)));
        this.conf.setProperty("storage.directory", (Object)berkeley.toAbsolutePath().toString());
        this.conf.setProperty("storage.backend", (Object)"berkeleyje");
        this.conf.setProperty("storage.berkeleyje.cache-percentage", (Object)1);
        this.conf.setProperty("storage.berkeleyje.lock-mode", (Object)LockMode.READ_UNCOMMITTED);
        this.conf.setProperty("storage.berkeleyje.isolation-level", (Object)BerkeleyJEStoreManager.IsolationLevel.READ_UNCOMMITTED);
        this.conf.setProperty("storage.buffer-size", (Object)"4096");
        this.conf.setProperty("storage.transactions", (Object)true);
        this.conf.setProperty("ids.block-size", (Object)25000);
        this.conf.setProperty("cache.db-cache", (Object)true);
        this.conf.setProperty("cache.db-cache-clean-wait", (Object)0);
        this.conf.setProperty("cache.db-cache-size", (Object)0.09);
        this.conf.setProperty("cache.db-cache-time", (Object)0);
        this.conf.setProperty("index.search.backend", (Object)"lucene");
        this.conf.setProperty("index.search.directory", (Object)lucene.toAbsolutePath().toString());
        this.writeToPropertiesFile(this.conf, this.graphDir.resolve("TitanConfiguration.properties").toFile());
        JanusGraph janusGraph = JanusGraphFactory.open((Configuration)this.conf);
        if (enableListeners) {
            TraversalStrategies graphStrategies = TraversalStrategies.GlobalCache.getStrategies(StandardJanusGraph.class).clone();
            if (graphStrategies.getStrategy(EventStrategy.class) != null) {
                graphStrategies.removeStrategies(new Class[]{EventStrategy.class});
            }
            graphStrategies.addStrategies(new TraversalStrategy[]{EventStrategy.build().addListener((MutationListener)mutationListener).create()});
            TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraph.class, (TraversalStrategies)graphStrategies);
            mutationListener.setGraph(this);
        }
        return janusGraph;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public GraphTypeManager getGraphTypeManager() {
        return this.graphTypeManager;
    }

    public void close() {
        try {
            Imported beforeCloseListeners = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(BeforeGraphCloseListener.class);
            for (BeforeGraphCloseListener listener : beforeCloseListeners) {
                if (this.beforeGraphCloseListenerBuffer.containsKey(listener.getClass().toString())) continue;
                this.beforeGraphCloseListenerBuffer.put(listener.getClass().toString(), listener);
            }
            for (BeforeGraphCloseListener listener : this.beforeGraphCloseListenerBuffer.values()) {
                listener.beforeGraphClose();
            }
            this.beforeGraphCloseListenerBuffer.clear();
        }
        catch (Exception e) {
            LOG.warning("Could not call before shutdown listeners during close due to: " + e.getMessage());
        }
        try {
            this.graph.close();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Failed to close graph at: " + this.graphDir + " due to: " + t.getMessage(), t);
        }
    }

    public void clear() {
        if (this.graph == null) {
            return;
        }
        if (this.graph.isOpen()) {
            this.close();
        }
        try {
            JanusGraphFactory.drop((JanusGraph)this.graph);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to delete graph due to: " + e.getMessage(), e);
        }
    }

    public JanusGraph getGraph() {
        return this.graph;
    }

    public WrappedFramedGraph<JanusGraph> getFramed() {
        return this.framed;
    }

    public Traversable<?, ?> getQuery(Class<? extends WindupVertexFrame> kind) {
        return this.getFramed().traverse(g -> this.getFramed().getTypeResolver().hasType(g.V(new Object[0]), kind));
    }

    public Path getGraphDirectory() {
        return this.graphDir;
    }

    public Map<String, Object> getOptionMap() {
        if (this.configurationOptions == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.configurationOptions);
    }

    public void setOptions(Map<String, Object> options) {
        this.configurationOptions = options;
    }

    public String toString() {
        String graphHash = this.getGraph() == null ? "null" : "" + this.getGraph().hashCode();
        return "GraphContextImpl(" + this.hashCode() + "), Graph(" + graphHash + ") + DataDir(" + this.getGraphDirectory() + ")";
    }

    private void writeToPropertiesFile(Configuration conf, File file) {
        try {
            PropertiesConfiguration properties = new PropertiesConfiguration();
            ConfigurationUtils.copy((Configuration)conf, (Configuration)properties);
            FileHandler handler = new FileHandler((FileBased)properties);
            handler.save(file);
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException("Failed writing JanusGraph config to " + file.getAbsolutePath() + ": " + ex.getMessage(), ex);
        }
    }

    public <T extends WindupVertexFrame> GraphService<T> service(Class<T> clazz) {
        return new GraphService((GraphContext)this, clazz);
    }

    public <T extends WindupVertexFrame> T getUnique(Class<T> clazz) {
        return (T)this.service(clazz).getUnique();
    }

    public <T extends WindupVertexFrame> Iterable<T> findAll(Class<T> clazz) {
        return this.service(clazz).findAll();
    }

    public <T extends WindupVertexFrame> T create(Class<T> clazz) {
        return (T)this.service(clazz).create();
    }

    public void commit() {
        this.getGraph().tx().commit();
    }

    private static class GraphContextMutationListener
    implements MutationListener {
        private GraphContextImpl graphContext;

        private GraphContextMutationListener() {
        }

        private void setGraph(GraphContextImpl graphContext) {
            this.graphContext = graphContext;
        }

        private GraphContextImpl getGraphContext() {
            return this.graphContext;
        }

        public void vertexAdded(Vertex vertex) {
            GraphContextImpl graphContext = this.getGraphContext();
            if (graphContext == null || graphContext.graphListeners == null) {
                return;
            }
            this.getGraphContext().graphListeners.forEach(listener -> listener.vertexAdded(vertex));
        }

        public void vertexPropertyChanged(Vertex vertex, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
            GraphContextImpl graphContext = this.getGraphContext();
            if (graphContext == null || graphContext.graphListeners == null) {
                return;
            }
            this.getGraphContext().graphListeners.forEach(listener -> listener.vertexPropertyChanged(vertex, (org.apache.tinkerpop.gremlin.structure.Property)oldValue, setValue, vertexPropertyKeyValues));
        }

        public void vertexRemoved(Vertex vertex) {
        }

        public void vertexPropertyRemoved(VertexProperty vertexProperty) {
        }

        public void edgeAdded(Edge edge) {
        }

        public void edgeRemoved(Edge edge) {
        }

        public void edgePropertyChanged(Edge element, org.apache.tinkerpop.gremlin.structure.Property oldValue, Object setValue) {
        }

        public void edgePropertyRemoved(Edge element, org.apache.tinkerpop.gremlin.structure.Property property) {
        }

        public void vertexPropertyPropertyChanged(VertexProperty element, org.apache.tinkerpop.gremlin.structure.Property oldValue, Object setValue) {
        }

        public void vertexPropertyPropertyRemoved(VertexProperty element, org.apache.tinkerpop.gremlin.structure.Property property) {
        }
    }

    private class IndexData {
        private final String propertyName;
        private final String indexName;
        private final Class<?> type;

        public IndexData(String propertyName, String indexName, Class<?> type) {
            this.propertyName = propertyName;
            this.indexName = indexName;
            this.type = type;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getIndexName() {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.indexName, (CharSequence)this.propertyName);
        }

        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return String.format("IndexData{propertyName='%s', indexName='%s', type=%s}", this.propertyName, this.indexName, this.type);
        }
    }
}

