/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.MethodHandler;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.jboss.windup.graph.MapInProperties;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class MapInPropertiesHandler
extends AbstractMethodHandler
implements MethodHandler {
    private static final Logger log = Logging.get(MapInPropertiesHandler.class);

    public Class<MapInProperties> getAnnotationType() {
        return MapInProperties.class;
    }

    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.createInterceptor(builder, method);
        }
        if (methodName.startsWith("set")) {
            return this.createInterceptor(builder, method);
        }
        if (methodName.startsWith("put")) {
            return this.createInterceptor(builder, method);
        }
        if (methodName.startsWith("putAll")) {
            return this.createInterceptor(builder, method);
        }
        throw new WindupException("Only get*, set*, and put* method names are supported for @" + MapInProperties.class.getSimpleName() + ", found at: " + method.getName());
    }

    private <E> DynamicType.Builder<E> createInterceptor(DynamicType.Builder<E> builder, Method method) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(MapInPropertiesInterceptor.class));
    }

    public static final class MapInPropertiesInterceptor {
        @RuntimeType
        public static Object execute(@This ElementFrame thisFrame, @Origin Method method, @RuntimeType @AllArguments Object[] args) {
            MapInProperties ann = (MapInProperties)((CachesReflection)thisFrame).getReflectionCache().getAnnotation(method, MapInProperties.class);
            Element thisElement = thisFrame.getElement();
            if (!(thisElement instanceof Vertex)) {
                throw new WindupException("Element is not of supported type, must be Vertex, but was: " + thisElement.getClass().getCanonicalName());
            }
            Vertex vertex = (Vertex)thisElement;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                return MapInPropertiesInterceptor.handleGetter(vertex, method, args, ann);
            }
            if (methodName.startsWith("set")) {
                return MapInPropertiesInterceptor.handleSetter(vertex, method, args, ann);
            }
            if (methodName.startsWith("put")) {
                return MapInPropertiesInterceptor.handleAdder(vertex, method, args, ann);
            }
            if (methodName.startsWith("putAll")) {
                return MapInPropertiesInterceptor.handleAdder(vertex, method, args, ann);
            }
            throw new WindupException("Only get*, set*, and put* method names are supported for @" + MapInProperties.class.getSimpleName() + ", found at: " + method.getName());
        }

        private static Map<String, Object> handleGetter(Vertex vertex, Method method, Object[] args, MapInProperties ann) {
            if (args != null && args.length != 0) {
                throw new WindupException("Method must take zero arguments");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String prefix = MapInPropertiesInterceptor.preparePrefix(ann);
            Set keys = vertex.keys();
            for (String key : keys) {
                if (!key.startsWith(prefix) || key.equals("w:winduptype")) continue;
                VertexProperty val = vertex.property(key);
                if (!ann.propertyType().isAssignableFrom(val.value().getClass())) {
                    log.warning("@InProperties is meant for Map<String," + ann.propertyType().getName() + ">, but the value was: " + val.getClass());
                }
                map.put(key.substring(prefix.length()), val.value());
            }
            return map;
        }

        private static WindupVertexFrame handleSetter(Vertex vertex, Method method, Object[] args, MapInProperties ann) {
            if (args == null || args.length != 1) {
                throw new WindupException("Method must take one argument: " + method.getName());
            }
            if (!(args[0] instanceof Map)) {
                throw new WindupException("Argument of " + method.getName() + " must be a Map, but is: " + args[0].getClass());
            }
            Map map = (Map)args[0];
            String prefix = MapInPropertiesInterceptor.preparePrefix(ann);
            Set keys = vertex.keys();
            Set mapKeys = map.keySet();
            for (String key : keys) {
                String subKey;
                if (!key.startsWith(prefix) || "w:winduptype".equals(key) || key.startsWith("w:")) continue;
                VertexProperty val = vertex.property(key);
                if (!ann.propertyType().isAssignableFrom(val.value().getClass())) {
                    log.warning("@InProperties is meant for Map<String," + ann.propertyType().getName() + ">, but the value was: " + val.getClass());
                }
                if (map.containsKey(subKey = key.substring(prefix.length()))) {
                    vertex.property(key, map.get(subKey));
                    mapKeys.remove(subKey);
                    continue;
                }
                vertex.property(key).remove();
            }
            for (String key : mapKeys) {
                vertex.property(prefix + key, map.get(key));
            }
            return null;
        }

        private static WindupVertexFrame handleAdder(Vertex vertex, Method method, Object[] args, MapInProperties ann) {
            if (args != null && args.length != 1) {
                throw new WindupException("Method '" + method.getName() + "' must take one argument, not " + args.length);
            }
            if (args == null || args[0] == null || !(args[0] instanceof Map)) {
                throw new WindupException("Method '" + method.getName() + "' must take one argument, a Map<String, Serializable> to store in the vertex. Was: " + (Serializable)(args == null || args[0] == null ? "null" : args[0].getClass()));
            }
            String prefix = MapInPropertiesInterceptor.preparePrefix(ann);
            Map map = (Map)args[0];
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Serializable)) {
                    throw new WindupException("The values of the map to store in a vertex must all implement Serializable.");
                }
                vertex.property(prefix + (String)entry.getKey(), value);
            }
            return null;
        }

        private static String preparePrefix(MapInProperties ann) {
            return "".equals(ann.propertyPrefix()) ? "" : ann.propertyPrefix() + ":";
        }
    }
}

