/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.ReflectionUtility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.Property;

public class WindupPropertyMethodHandler
extends AbstractMethodHandler {
    public Class<Property> getAnnotationType() {
        return Property.class;
    }

    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        Parameter[] arguments = method.getParameters();
        if (ReflectionUtility.isSetMethod((Method)method)) {
            if (arguments == null || arguments.length == 0) {
                throw new IllegalStateException(method.getName() + " was annotated with @Property but had no arguments.");
            }
            if (arguments.length == 1) {
                return this.setProperty(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Property but had more than 1 arguments.");
        }
        if (ReflectionUtility.isGetMethod((Method)method)) {
            if (arguments == null || arguments.length == 0) {
                return this.getProperty(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Property but had arguments.");
        }
        if (ReflectionUtility.isRemoveMethod((Method)method)) {
            if (arguments == null || arguments.length == 0) {
                return this.removeProperty(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Property but had some arguments.");
        }
        throw new IllegalStateException(method.getName() + " was annotated with @Property but did not begin with either of the following keywords: add, get");
    }

    private <E> DynamicType.Builder<E> setProperty(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(SetPropertyInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getProperty(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetPropertyInterceptor.class));
    }

    private <E> DynamicType.Builder<E> removeProperty(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(RemovePropertyInterceptor.class));
    }

    private static Enum getValueAsEnum(Method method, Object value) {
        Class<?> en = method.getReturnType();
        if (value != null) {
            return Enum.valueOf(en, value.toString());
        }
        return null;
    }

    public static final class RemovePropertyInterceptor {
        public static void removeProperty(@This ElementFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Property annotation = (Property)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Property.class);
            String propertyName = annotation.value();
            Element element = thiz.getElement();
            if (element instanceof Vertex) {
                thiz.getGraph().getRawTraversal().V(new Object[]{element.id()}).properties(new String[]{propertyName}).drop().iterate();
            } else {
                thiz.getGraph().getRawTraversal().E(new Object[]{element.id()}).properties(new String[]{propertyName}).drop().iterate();
            }
            thiz.getElement().property(propertyName).remove();
        }
    }

    public static final class SetPropertyInterceptor {
        @RuntimeType
        public static void setProperty(@This ElementFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Object obj) {
            assert (thiz instanceof CachesReflection);
            Property annotation = (Property)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Property.class);
            String propertyName = annotation.value();
            Object propertyValue = obj != null && obj.getClass().isEnum() ? ((Enum)obj).name() : obj;
            if (propertyValue == null) {
                RemovePropertyInterceptor.removeProperty(thiz, method);
                return;
            }
            Element element = thiz.getElement();
            if (element instanceof Vertex) {
                thiz.getGraph().getRawTraversal().V(new Object[]{element.id()}).property((Object)propertyName, propertyValue, new Object[0]).iterate();
            } else {
                thiz.getGraph().getRawTraversal().E(new Object[]{element.id()}).property((Object)propertyName, propertyValue, new Object[0]).iterate();
            }
        }
    }

    public static final class GetPropertyInterceptor {
        @RuntimeType
        public static Object getProperty(@This ElementFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Property annotation = (Property)((CachesReflection)thiz).getReflectionCache().getAnnotation(method, Property.class);
            String value = annotation.value();
            Object obj = thiz.getProperty(value);
            if (method.getReturnType().isEnum()) {
                return WindupPropertyMethodHandler.getValueAsEnum(method, obj);
            }
            return obj;
        }
    }
}

