/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.javahandler;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.ReflectionCache;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.MethodHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.jboss.windup.graph.JavaHandler;
import org.jboss.windup.util.exception.WindupException;

public class JavaHandlerHandler
extends AbstractMethodHandler
implements MethodHandler {
    public Class<JavaHandler> getAnnotationType() {
        return JavaHandler.class;
    }

    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return this.createInterceptor(builder, method);
    }

    private <E> DynamicType.Builder<E> createInterceptor(DynamicType.Builder<E> builder, Method method) {
        return builder.define(method).intercept((Implementation)MethodDelegation.to(JavaHandlerInterceptor.class)).annotateMethod(method.getAnnotations());
    }

    public static final class JavaHandlerInterceptor {
        @RuntimeType
        public static Object execute(@This ElementFrame thisFrame, @Origin Method method, @RuntimeType @AllArguments Object[] args) {
            ReflectionCache reflectionCache = ((CachesReflection)thisFrame).getReflectionCache();
            JavaHandler ann = (JavaHandler)reflectionCache.getAnnotation(method, JavaHandler.class);
            try {
                Class handlerClass = ann.handler();
                Method handlerMethod = JavaHandlerInterceptor.findMethodHandler(method, handlerClass);
                if (handlerMethod == null) {
                    throw new WindupException("Could not find method on handler with name: " + method.getName());
                }
                Object handler = handlerClass.newInstance();
                if (handlerMethod.getParameterTypes().length == args.length + 1) {
                    ArrayList<Object> newArgs = new ArrayList<Object>();
                    newArgs.add(thisFrame);
                    newArgs.addAll(Arrays.asList(args));
                    args = newArgs.toArray(new Object[newArgs.size()]);
                }
                return handlerMethod.invoke(handler, args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new WindupException((Throwable)e);
            }
        }

        private static Method findMethodHandler(Method originalMethod, Class handlerClass) {
            for (Method candidateMethod : handlerClass.getMethods()) {
                if (!candidateMethod.getName().equals(originalMethod.getName())) continue;
                return candidateMethod;
            }
            return null;
        }
    }
}

