/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.MavenContainer;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;

@Mojo(name="windup", requiresDependencyResolution=ResolutionScope.COMPILE, aggregator=true)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class WindupMojo
extends AbstractMojo {
    private static final String VERSION_DEFINITIONS_FILE = "META-INF/versions.properties";
    @Parameter(defaultValue="${project.build.directory}")
    private String buildDirectory;
    @Parameter(alias="output", property="output", defaultValue="${project.build.directory}/windup-report", required=true)
    private String outputDirectory;
    @Parameter(alias="input", property="input", required=true, defaultValue="${project.build.sourceDirectory}")
    private String inputDirectory;
    @Parameter(alias="packages", property="packages", required=true)
    private List<String> packages;
    @Parameter(alias="excludePackages", property="excludePackages", required=false)
    private List<String> excludePackages;
    @Parameter(alias="offline", property="offline", required=false)
    private Boolean offlineMode;
    @Parameter(alias="sourceMode", property="sourceMode", required=false, defaultValue="true")
    private Boolean sourceMode;
    @Parameter(alias="overwrite", property="overwrite", required=false)
    private Boolean overwrite;
    @Parameter(alias="userIgnorePath", property="userIgnorePath", required=false)
    private String userIgnorePath;
    @Parameter(alias="userRulesDirectory", property="userRulesDirectory", required=false)
    private String userRulesDirectory;
    @Parameter(alias="includeTags", property="includeTags", required=false)
    private List<String> includeTags;
    @Parameter(alias="excludeTags", property="excludeTags", required=false)
    private List<String> excludeTags;
    @Parameter(alias="sourceTechnologies", property="sourceTechnologies", required=false)
    private List<String> sources;
    @Parameter(alias="targetTechnologies", property="targetTechnologies", required=false)
    private List<String> targets;
    @Parameter(alias="windupVersion", property="windupVersion", required=false)
    private String windupVersion;
    @Parameter(alias="keepWorkDirs", property="keepWorkDirs", required=false)
    private Boolean keepWorkDirs;
    @Parameter(alias="explodedApps", property="explodedApps", required=false)
    private Boolean explodedApps;
    @Parameter(alias="exportCSV", property="exportCSV", required=false)
    private Boolean exportCSV;
    @Parameter(alias="enableTattletale", property="enableTattletale", required=false)
    private Boolean enableTattletale;
    @Parameter(alias="enableCompatibleFilesReport", property="enableCompatibleFilesReport", required=false)
    private Boolean enableCompatibleFilesReport;
    private static final String WINDUP_RULES_GROUP_ID = "org.jboss.windup.rules";
    private static final String WINDUP_RULES_ARTIFACT_ID = "windup-rulesets";

    public void execute() throws MojoExecutionException {
        Properties versions;
        System.setProperty("windup.home", Paths.get(this.buildDirectory, "winduphome").toString());
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        windupConfiguration.addInputPath(Paths.get(this.inputDirectory, new String[0]));
        windupConfiguration.setOutputDirectory(Paths.get(this.outputDirectory, new String[0]));
        this.packages = this.normalizePackages(this.packages);
        this.excludePackages = this.normalizePackages(this.excludePackages);
        windupConfiguration.setOptionValue("packages", this.packages);
        windupConfiguration.setOptionValue("excludePackages", this.excludePackages);
        windupConfiguration.setOffline(this.offlineMode == Boolean.TRUE);
        windupConfiguration.setOptionValue("sourceMode", (Object)(this.sourceMode == Boolean.TRUE ? 1 : 0));
        windupConfiguration.setOptionValue("explodedApp", (Object)(this.explodedApps == Boolean.TRUE ? 1 : 0));
        windupConfiguration.setOptionValue("overwrite", (Object)(this.overwrite == Boolean.TRUE ? 1 : 0));
        windupConfiguration.setOptionValue("includeTags", this.includeTags);
        windupConfiguration.setOptionValue("excludeTags", this.excludeTags);
        windupConfiguration.setOptionValue("source", this.sources);
        windupConfiguration.setOptionValue("target", this.targets);
        windupConfiguration.setOptionValue("keepWorkDirs", (Object)(this.keepWorkDirs == Boolean.TRUE ? 1 : 0));
        windupConfiguration.setOptionValue("enableCompatibleFilesReport", (Object)this.enableCompatibleFilesReport);
        windupConfiguration.setOptionValue("enableTattletale", (Object)(this.enableTattletale == Boolean.TRUE ? 1 : 0));
        windupConfiguration.setExportingCSV(this.exportCSV == Boolean.TRUE);
        this.downloadAndUnzipRules();
        windupConfiguration.addDefaultUserRulesDirectory(PathUtil.getWindupRulesDir());
        if (this.userRulesDirectory != null && !Files.isDirectory(Paths.get(this.userRulesDirectory, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(Paths.get(this.userRulesDirectory, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.userRulesDirectory != null) {
            windupConfiguration.addDefaultUserRulesDirectory(Paths.get(this.userRulesDirectory, new String[0]));
        }
        if (this.userIgnorePath == null) {
            this.userIgnorePath = PathUtil.getWindupIgnoreDir().toString();
        }
        windupConfiguration.addDefaultUserIgnorePath(Paths.get(this.userIgnorePath, new String[0]));
        try {
            versions = this.loadVersions(VERSION_DEFINITIONS_FILE);
        }
        catch (IOException ex) {
            String msg = "Can't load the version definitions from classpath: META-INF/versions.properties";
            throw new MojoExecutionException("Can't load the version definitions from classpath: META-INF/versions.properties", (Exception)ex);
        }
        String furnaceVersion = versions.getProperty("version.furnace");
        if (furnaceVersion == null) {
            throw new MojoExecutionException("Internal error: Version of Furnace was not defined.");
        }
        String forgeVersion = versions.getProperty("version.forge");
        if (forgeVersion == null) {
            throw new MojoExecutionException("Internal error: Version of Forge was not defined.");
        }
        String windupVersion_ = versions.getProperty("version.windup");
        if (null != windupVersion_) {
            this.windupVersion = windupVersion_;
        }
        if (null == this.windupVersion) {
            throw new MojoExecutionException("Internal error: Version of Windup which should be used was not defined.");
        }
        Furnace furnace = WindupMojo.createAndStartFurnace();
        this.install("org.jboss.forge.furnace.container:simple," + furnaceVersion, furnace);
        this.install("org.jboss.forge.addon:core," + forgeVersion, furnace);
        this.install("org.jboss.windup:windup-tooling," + this.windupVersion, furnace);
        this.install("org.jboss.windup.rules.apps:windup-rules-java-project," + this.windupVersion, furnace);
        if (this.enableTattletale == Boolean.TRUE) {
            this.install("org.jboss.windup.rules.apps:windup-rules-tattletale," + this.windupVersion, furnace);
        }
        AddonRegistry addonRegistry = furnace.getAddonRegistry(new AddonRepository[0]);
        WindupProcessor windupProcessor = (WindupProcessor)addonRegistry.getServices(WindupProcessor.class).get();
        GraphContextFactory graphContextFactory = (GraphContextFactory)addonRegistry.getServices(GraphContextFactory.class).get();
        Path graphPath = windupConfiguration.getOutputDirectory().resolve("graph");
        try (GraphContext graphContext = graphContextFactory.create(graphPath);){
            windupConfiguration.setGraphContext(graphContext);
            windupProcessor.execute(windupConfiguration);
            this.getLog().info((CharSequence)("\n\n==========================================================================================================================\n\n    Windup report created: " + windupConfiguration.getOutputDirectory().toAbsolutePath() + "/index.html\n\n==========================================================================================================================\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void downloadAndUnzipRules() {
        MavenContainer mavenContainer = new MavenContainer();
        RepositorySystem system = mavenContainer.getRepositorySystem();
        Settings settings = mavenContainer.getSettings();
        DefaultRepositorySystemSession session = mavenContainer.setupRepoSession(system, settings);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)new DefaultArtifact("org.jboss.windup.rules:windup-rulesets:" + this.windupVersion));
        try {
            ArtifactResult artifactResult = mavenContainer.getRepositorySystem().resolveArtifact((RepositorySystemSession)session, artifactRequest);
            Path outputDirectory = PathUtil.getWindupRulesDir();
            if (!Files.isDirectory(outputDirectory, new LinkOption[0])) {
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            ZipUtil.unzipToFolder((File)artifactResult.getArtifact().getFile(), (File)outputDirectory.toFile());
        }
        catch (IOException | ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Furnace createAndStartFurnace() {
        Furnace furnace = FurnaceFactory.getInstance();
        furnace.addRepository(AddonRepositoryMode.MUTABLE, new File("target/addons"));
        System.setProperty("INTERACTIVE", "false");
        Future future = furnace.startAsync();
        try {
            return (Furnace)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new WindupException("Failed to start Furnace: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void install(String addonCoordinates, Furnace furnace) {
        Version runtimeAPIVersion = AddonRepositoryImpl.getRuntimeAPIVersion();
        try {
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(furnace, (AddonDependencyResolver)resolver);
            AddonId addon = null;
            addon = addonCoordinates.contains(",") ? AddonId.fromCoordinates((String)addonCoordinates) : this.pickLatestAddonVersion((AddonDependencyResolver)resolver, addonCoordinates, runtimeAPIVersion, addon);
            if (addon == null) {
                throw new IllegalArgumentException("No compatible addon API version found for " + addonCoordinates + " for API " + runtimeAPIVersion);
            }
            InstallRequest request = addonManager.install(addon);
            this.getLog().info((CharSequence)("Requesting to install: " + request.toString()));
            request.perform();
            this.getLog().info((CharSequence)"Installation completed successfully.\n");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            this.getLog().error((CharSequence)("> Forge version [" + runtimeAPIVersion + "]"));
        }
    }

    private AddonId pickLatestAddonVersion(AddonDependencyResolver resolver, String addonCoordinates, Version runtimeAPIVersion, AddonId addon) throws IllegalArgumentException {
        AddonId[] versions = (AddonId[])resolver.resolveVersions(addonCoordinates).get();
        if (versions.length == 0) {
            throw new IllegalArgumentException("No Artifact version found for " + addonCoordinates);
        }
        for (int i = versions.length - 1; i >= 0; --i) {
            String apiVersion = (String)resolver.resolveAPIVersion(versions[i]).get();
            if (apiVersion == null || !Versions.isApiCompatible((Version)runtimeAPIVersion, (Version)SingleVersion.valueOf((String)apiVersion))) continue;
            return versions[i];
        }
        return null;
    }

    private Properties loadVersions(String path) throws IOException {
        InputStream propsFile = WindupMojo.class.getClassLoader().getResourceAsStream(path);
        Properties props = new Properties();
        props.load(propsFile);
        return props;
    }

    private List<String> normalizePackages(List<String> packages) {
        if (packages == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(packages.size());
        for (String pkg : packages) {
            if (pkg.endsWith(".*")) {
                this.getLog().warn((CharSequence)("Warning: removing the .* suffix from the package prefix: " + pkg));
            }
            result.add(StringUtils.removeEndIgnoreCase((String)pkg, (String)".*"));
        }
        return packages;
    }
}

