/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files.condition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.config.condition.NoopEvaluationStrategy;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.config.parameters.ParameterizedGraphCondition;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.FileReferenceModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.files.condition.FileFrom;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.util.Maps;

public class File
extends ParameterizedGraphCondition {
    private static final Logger LOG = Logging.get(File.class);
    private RegexParameterizedPatternParser filenamePattern;

    public static FileFrom from(String from) {
        FileFrom f = new FileFrom();
        f.setFrom(from);
        return f;
    }

    public static File inFileNamed(String filenamePattern) {
        File f = new File();
        f.filenamePattern = new RegexParameterizedPatternParser(filenamePattern);
        return f;
    }

    public ConditionBuilder as(String variable) {
        Assert.notNull((Object)variable, (String)"Variable name must not be null.");
        this.setOutputVariablesName(variable);
        return this;
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.filenamePattern != null) {
            result.addAll(this.filenamePattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.filenamePattern != null) {
            this.filenamePattern.setParameterStore(store);
        }
    }

    protected String getVarname() {
        return this.getOutputVariablesName();
    }

    protected boolean evaluateAndPopulateValueStores(GraphRewrite event, EvaluationContext context, final FrameCreationContext frameCreationContext) {
        return this.evaluate(event, context, new EvaluationStrategy(){
            private LinkedHashMap<String, List<WindupVertexFrame>> variables;

            public void modelMatched() {
                this.variables = new LinkedHashMap();
                frameCreationContext.beginNew(this.variables);
            }

            public void modelSubmitted(WindupVertexFrame model) {
                Maps.addListValue(this.variables, (Object)File.this.getVarname(), (Object)model);
            }

            public void modelSubmissionRejected() {
                frameCreationContext.rollback();
            }
        });
    }

    protected boolean evaluateWithValueStore(GraphRewrite event, EvaluationContext context, FrameContext frameContext) {
        boolean result = this.evaluate(event, context, (EvaluationStrategy)new NoopEvaluationStrategy());
        if (!result) {
            frameContext.reject();
        }
        return result;
    }

    private boolean evaluate(GraphRewrite event, EvaluationContext context, EvaluationStrategy evaluationStrategy) {
        ParameterStore store = DefaultParameterStore.getInstance((EvaluationContext)context);
        GraphService fileLocationService = new GraphService(event.getGraphContext(), FileLocationModel.class);
        ArrayList<FileModel> fileModels = new ArrayList<FileModel>();
        this.fromInput(fileModels, event);
        this.fileNameInput(fileModels, event, store);
        this.allInput(fileModels, event, store);
        ArrayList<FileLocationModel> results = new ArrayList<FileLocationModel>();
        for (FileModel fileModel : fileModels) {
            if (fileModel.isDirectory()) continue;
            ParameterizedPatternResult parsedFileNamePattern = this.filenamePattern.parse(fileModel.getFileName());
            evaluationStrategy.modelMatched();
            if (parsedFileNamePattern == null || parsedFileNamePattern.submit((Rewrite)event, context)) {
                FileLocationModel fileLocationModel = (FileLocationModel)fileLocationService.create();
                fileLocationModel.setFile(fileModel);
                fileLocationModel.setColumnNumber(1);
                fileLocationModel.setLineNumber(1);
                fileLocationModel.setLength(1);
                fileLocationModel.setSourceSnippit("File Match");
                results.add(fileLocationModel);
                evaluationStrategy.modelSubmitted((WindupVertexFrame)fileLocationModel);
                continue;
            }
            evaluationStrategy.modelSubmissionRejected();
        }
        this.setResults(event, this.getVarname(), results);
        return !results.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)((Object)this)).getClass().getSimpleName());
        builder.append(".from(").append(this.getInputVariablesName()).append(")");
        builder.append(".inFilesNamed(").append(this.filenamePattern).append(")");
        builder.append(".as(").append(this.getVarname()).append(")");
        return builder.toString();
    }

    private void fromInput(List<FileModel> vertices, GraphRewrite event) {
        if (vertices.isEmpty() && StringUtils.isNotBlank((CharSequence)this.getInputVariablesName())) {
            for (WindupVertexFrame windupVertexFrame : Variables.instance((GraphRewrite)event).findVariable(this.getInputVariablesName())) {
                if (windupVertexFrame instanceof FileModel) {
                    vertices.add((FileModel)windupVertexFrame);
                }
                if (!(windupVertexFrame instanceof FileReferenceModel)) continue;
                vertices.add(((FileReferenceModel)windupVertexFrame).getFile());
            }
        }
    }

    private void fileNameInput(List<FileModel> vertices, GraphRewrite event, ParameterStore store) {
        if (this.filenamePattern != null) {
            Pattern filenameRegex = this.filenamePattern.getCompiledPattern(store);
            if (vertices.isEmpty() && StringUtils.isBlank((CharSequence)this.getInputVariablesName())) {
                FileService fileModelService = new FileService(event.getGraphContext());
                for (FileModel fileModel2 : fileModelService.findByFilenameRegex(filenameRegex.pattern())) {
                    vertices.add(fileModel2);
                }
            } else {
                vertices.removeIf(fileModel -> !filenameRegex.matcher(fileModel.getFileName()).matches());
            }
        }
    }

    private void allInput(List<FileModel> vertices, GraphRewrite event, ParameterStore store) {
        if (StringUtils.isBlank((CharSequence)this.getInputVariablesName()) && this.filenamePattern == null) {
            FileService fileModelService = new FileService(event.getGraphContext());
            for (FileModel fileModel : fileModelService.findAll()) {
                vertices.add(fileModel);
            }
        }
    }

    public void setFilenamePattern(RegexParameterizedPatternParser filenamePattern) {
        this.filenamePattern = filenamePattern;
    }
}

