/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.model;

import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;

@TypeValue(value="JavaClassFileModel")
public interface JavaClassFileModel
extends FileModel {
    public static final String MINOR_VERSION = "minorVersion";
    public static final String MAJOR_VERSION = "majorVersion";
    public static final String TYPE = "JavaClassFileModel";
    public static final String PROPERTY_PACKAGE_NAME = "packageName";
    public static final String SKIP_DECOMPILATION = "skipDecompilation";
    public static final String DECOMPILED_FILE = "decompiledFile";

    @Property(value="skipDecompilation")
    public Boolean getSkipDecompilation();

    @Property(value="skipDecompilation")
    public void setSkipDecompilation(boolean var1);

    @Property(value="packageName")
    public String getPackageName();

    @Indexed
    @Property(value="packageName")
    public void setPackageName(String var1);

    @Adjacency(label="javaClass", direction=Direction.OUT)
    public void setJavaClass(JavaClassModel var1);

    @Adjacency(label="javaClass", direction=Direction.OUT)
    public JavaClassModel getJavaClass();

    @Property(value="majorVersion")
    public int getMajorVersion();

    @Property(value="majorVersion")
    public void setMajorVersion(int var1);

    @Property(value="minorVersion")
    public int getMinorVersion();

    @Property(value="minorVersion")
    public void setMinorVersion(int var1);

    default public String getPrettyPathWithinProject(boolean useFQNForClasses) {
        if (!useFQNForClasses) {
            return this.getPrettyPathWithinProject();
        }
        JavaClassModel javaClass = this.getJavaClass();
        String result = javaClass == null ? this.getPrettyPathWithinProject() : javaClass.getQualifiedName();
        return result;
    }
}

