/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.model;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.model.BelongsToProject;
import org.jboss.windup.graph.model.HasApplications;
import org.jboss.windup.graph.model.HasProject;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;

@TypeValue(value="JavaClassModel")
public interface JavaClassModel
extends WindupVertexFrame,
BelongsToProject,
HasApplications,
HasProject {
    public static final String TYPE = "JavaClassModel";
    public static final String JAVA_METHOD = "javaMethod";
    public static final String CLASS_FILE = "classFile";
    public static final String ORIGINAL_SOURCE = "originalSource";
    public static final String DECOMPILED_SOURCE = "decompiledSource";
    public static final String INTERFACES = "interfaces";
    public static final String EXTENDS = "extends";
    public static final String QUALIFIED_NAME = "qualifiedName";
    public static final String CLASS_NAME = "className";
    public static final String PACKAGE_NAME = "packageName";
    public static final String IS_PUBLIC = "isPublic";
    public static final String IS_INTERFACE = "isInterface";
    public static final String MAJOR_VERSION = "majorVersion";
    public static final String MINOR_VERSION = "minorVersion";

    @Property(value="isPublic")
    public Boolean isPublic();

    @Property(value="isPublic")
    public void setPublic(boolean var1);

    @Property(value="isInterface")
    public Boolean isInterface();

    @Property(value="isInterface")
    public void setInterface(boolean var1);

    @Property(value="className")
    public void setSimpleName(String var1);

    @Property(value="className")
    public String getClassName();

    @Indexed
    @Property(value="qualifiedName")
    public String getQualifiedName();

    @Property(value="qualifiedName")
    public void setQualifiedName(String var1);

    @Indexed
    @Property(value="packageName")
    public String getPackageName();

    @Property(value="packageName")
    public void setPackageName(String var1);

    @Adjacency(label="extends", direction=Direction.OUT)
    public JavaClassModel getExtends();

    @Adjacency(label="extends", direction=Direction.OUT)
    public void setExtends(JavaClassModel var1);

    @Adjacency(label="interfaces", direction=Direction.OUT)
    public void addInterface(JavaClassModel var1);

    @Adjacency(label="interfaces", direction=Direction.OUT)
    public List<JavaClassModel> getInterfaces();

    @Adjacency(label="interfaces", direction=Direction.IN)
    public List<JavaClassModel> getImplementedBy();

    @Adjacency(label="decompiledSource", direction=Direction.OUT)
    public void setDecompiledSource(JavaSourceFileModel var1);

    @Adjacency(label="decompiledSource", direction=Direction.OUT)
    public JavaSourceFileModel getDecompiledSource();

    @Adjacency(label="originalSource", direction=Direction.OUT)
    public void setOriginalSource(AbstractJavaSourceModel var1);

    @Adjacency(label="originalSource", direction=Direction.OUT)
    public AbstractJavaSourceModel getOriginalSource();

    @Adjacency(label="classFile", direction=Direction.OUT)
    public FileModel getClassFile();

    @Adjacency(label="classFile", direction=Direction.OUT)
    public FileModel setClassFile(FileModel var1);

    default public List<JavaMethodModel> getMethod(String methodName) {
        List vertices = new GraphTraversalSource((Graph)this.getWrappedGraph().getBaseGraph()).V(new Object[]{this.getElement()}).out(new String[]{JAVA_METHOD}).has("methodName", (Object)methodName).toList();
        return vertices.stream().map(v -> (JavaMethodModel)this.getGraph().frameElement((Element)v, JavaMethodModel.class)).collect(Collectors.toList());
    }

    @Adjacency(label="javaMethod", direction=Direction.OUT)
    public void addJavaMethod(JavaMethodModel var1);

    @Adjacency(label="javaMethod", direction=Direction.OUT)
    public List<JavaMethodModel> getJavaMethods();

    default public List<ProjectModel> getApplications() {
        FileModel sourceModel = this.getSourceFile();
        if (sourceModel == null) {
            return Collections.emptyList();
        }
        return sourceModel.getApplications();
    }

    default public ProjectModel getProjectModel() {
        FileModel sourceModel = this.getSourceFile();
        if (sourceModel == null) {
            return null;
        }
        return sourceModel.getProjectModel();
    }

    default public FileModel getSourceFile() {
        FileModel classFile = this.getClassFile();
        if (classFile == null) {
            AbstractJavaSourceModel originalSource = this.getOriginalSource();
            if (originalSource == null) {
                String name = this.getClassName();
                Logger.getLogger(JavaClassModel.class.getName()).log(Level.WARNING, "ClassFile and originalSource null for class: {0}", name);
                return null;
            }
            return originalSource;
        }
        return classFile;
    }

    default public boolean belongsToProject(ProjectModel projectModel) {
        FileModel sourceModel = this.getSourceFile();
        if (sourceModel == null) {
            return false;
        }
        return sourceModel.belongsToProject(projectModel);
    }
}

