/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.model;

import com.syncleus.ferma.ElementFrame;
import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.model.PackageModel;

@TypeValue(value="WindupJavaConfigurationModel")
public interface WindupJavaConfigurationModel
extends WindupVertexFrame,
ElementFrame {
    public static final String TYPE = "WindupJavaConfigurationModel";
    public static final String SOURCE_MODE = "sourceMode";
    public static final String EXCLUDE_JAVA_PACKAGES = "excludeJavaPackages";
    public static final String SCAN_JAVA_PACKAGES = "scanJavaPackages";
    public static final String IGNORED_FILES = "ignoredFiles";
    public static final String ADDITIONAL_CLASSPATHS = "additionalClasspath";
    public static final String CLASS_NOT_FOUND_ANALYSIS_ENABLED = "classNotFoundAnalysisEnabled";

    @Adjacency(label="scanJavaPackages", direction=Direction.OUT)
    public void setScanJavaPackages(Iterable<PackageModel> var1);

    @Adjacency(label="scanJavaPackages", direction=Direction.OUT)
    public List<PackageModel> getScanJavaPackages();

    @Adjacency(label="ignoredFiles", direction=Direction.OUT)
    public void addIgnoredFileRegex(IgnoredFileRegexModel var1);

    @Adjacency(label="ignoredFiles", direction=Direction.OUT)
    public List<IgnoredFileRegexModel> getIgnoredFileRegexes();

    default public void setScanJavaPackageList(Iterable<String> pkgs) {
        this.setScanJavaPackages(new ArrayList<PackageModel>());
        if (pkgs == null) {
            return;
        }
        for (String pkg : pkgs) {
            PackageModel m = (PackageModel)this.getGraph().addFramedVertex(PackageModel.class);
            m.setPackageName(pkg);
            this.addScanJavaPackages(m);
        }
    }

    @Adjacency(label="scanJavaPackages", direction=Direction.OUT)
    public void addScanJavaPackages(PackageModel var1);

    @Adjacency(label="excludeJavaPackages", direction=Direction.OUT)
    public void setExcludeJavaPackages(Iterable<PackageModel> var1);

    default public void setExcludeJavaPackageList(Iterable<String> pkgs) {
        this.setExcludeJavaPackages(new ArrayList<PackageModel>());
        if (pkgs == null) {
            return;
        }
        for (String pkg : pkgs) {
            PackageModel m = (PackageModel)this.getGraph().addFramedVertex(PackageModel.class);
            m.setPackageName(pkg);
            this.addExcludeJavaPackage(m);
        }
    }

    @Adjacency(label="excludeJavaPackages", direction=Direction.OUT)
    public void addExcludeJavaPackage(PackageModel var1);

    @Adjacency(label="excludeJavaPackages", direction=Direction.OUT)
    public List<PackageModel> getExcludeJavaPackages();

    @Property(value="sourceMode")
    public boolean isSourceMode();

    @Property(value="sourceMode")
    public void setSourceMode(boolean var1);

    @Property(value="classNotFoundAnalysisEnabled")
    public boolean isClassNotFoundAnalysisEnabled();

    @Property(value="classNotFoundAnalysisEnabled")
    public void setClassNotFoundAnalysisEnabled(boolean var1);

    @Adjacency(label="additionalClasspath", direction=Direction.OUT)
    public List<FileModel> getAdditionalClasspaths();

    @Adjacency(label="additionalClasspath", direction=Direction.OUT)
    public void addAdditionalClasspath(FileModel var1);
}

