/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.forge.furnace.util.Sets;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.util.ExecutionStatistics;

public class FindFilesNotClassifiedOrHintedGremlinCriterion {
    public Iterable<Vertex> query(GraphContext context, Iterable<Vertex> initialVertices) {
        ExecutionStatistics.get().begin("FindFilesNotClassifiedOrHintedGremlinCriterion.total");
        Set initialVerticesList = Sets.toSet(initialVertices);
        GraphTraversal pipeline = new GraphTraversalSource((Graph)context.getGraph()).V(new Object[]{initialVertices});
        HashSet allClassifiedOrHintedVertices = new HashSet();
        ExecutionStatistics.get().begin("FindFilesNotClassifiedOrHintedGremlinCriterion.hintPipeline");
        new GraphTraversalSource((Graph)context.getGraph()).V(new Object[]{context.getQuery(InlineHintModel.class).getRawTraversal().toList()}).as("fileLocation1", new String[0]).out(new String[]{"file"}).filter(v -> initialVerticesList.contains(v.get())).fill(allClassifiedOrHintedVertices);
        ExecutionStatistics.get().end("FindFilesNotClassifiedOrHintedGremlinCriterion.hintPipeline");
        ExecutionStatistics.get().begin("FindFilesNotClassifiedOrHintedGremlinCriterion.classificationPipeline");
        new GraphTraversalSource((Graph)context.getGraph()).V(new Object[]{context.getQuery(ClassificationModel.class).getRawTraversal().toList()}).as("fileModel2", new String[0]).out(new String[]{"ClassificationModel-classificationModelToFileModel"}).filter(v -> initialVerticesList.contains(v.get())).fill(allClassifiedOrHintedVertices);
        ExecutionStatistics.get().end("FindFilesNotClassifiedOrHintedGremlinCriterion.classificationPipeline");
        pipeline.filter(it -> {
            JavaSourceFileModel source;
            Iterator decompiled;
            Vertex v = (Vertex)it.get();
            FileModel f = (FileModel)context.getFramed().frameElement((Element)v, FileModel.class);
            if (allClassifiedOrHintedVertices.contains(v)) {
                return false;
            }
            if (f.isWindupGenerated() != null && f.isWindupGenerated().booleanValue()) {
                return false;
            }
            return !(f instanceof JavaClassFileModel) || !(decompiled = v.vertices(Direction.OUT, new String[]{"decompiledFile"})).hasNext() || !allClassifiedOrHintedVertices.contains(source = (JavaSourceFileModel)context.getFramed().frameElement((Element)decompiled.next(), JavaSourceFileModel.class));
        });
        ExecutionStatistics.get().end("FindFilesNotClassifiedOrHintedGremlinCriterion.total");
        return pipeline.toList();
    }
}

