/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerTemplateDirective;
import org.jboss.windup.rules.apps.java.service.TypeReferenceService;
import org.jboss.windup.util.exception.WindupException;

public class RenderApplicationPieChartDirective
implements WindupFreeMarkerTemplateDirective {
    public static final String NAME = "render_pie";
    private GraphContext context;

    public String getDescription() {
        return "Renders a pie chart. Takes the following parameters: project (a " + ProjectModel.class.getSimpleName() + "), recursive (Boolean), and elementid (HTML ID of the element in which to render).";
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        StringModel projectStringModel = (StringModel)params.get("project");
        ProjectModel projectModel = null;
        if (projectStringModel != null) {
            projectModel = (ProjectModel)projectStringModel.getWrappedObject();
        }
        StringModel projectTraversalStringModel = (StringModel)params.get("projectTraversal");
        ProjectModelTraversal projectTraversal = null;
        if (projectTraversalStringModel != null) {
            projectTraversal = (ProjectModelTraversal)projectTraversalStringModel.getWrappedObject();
        }
        if (projectModel != null && projectTraversal != null) {
            throw new WindupException("render_pie both 'project' and 'projectTraversal' were specified. Only one of these values should be specified.");
        }
        if (projectModel == null && projectTraversal == null) {
            throw new WindupException("render_pie neither 'project' nor 'projectTraversal' were specified. At least one of these must be specified.");
        }
        TemplateBooleanModel recursiveBooleanModel = (TemplateBooleanModel)params.get("recursive");
        boolean recursive = recursiveBooleanModel.getAsBoolean();
        SimpleScalar elementIDStringModel = (SimpleScalar)params.get("elementID");
        String elementID = elementIDStringModel.getAsString();
        Set includeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)params.get("includeTags")));
        Set excludeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)params.get("excludeTags")));
        TypeReferenceService typeReferenceService = new TypeReferenceService(this.context);
        Map<String, Integer> data = projectModel != null ? typeReferenceService.getPackageUseFrequencies(projectModel, (Set<String>)includeTags, (Set<String>)excludeTags, 2, recursive) : typeReferenceService.getPackageUseFrequencies(projectTraversal, (Set<String>)includeTags, (Set<String>)excludeTags, 2, recursive);
        if (data.keySet().size() > 0) {
            this.drawPie(env.getOut(), data, elementID);
        } else {
            Writer writer = env.getOut();
            writer.append("<script type='text/javascript'>");
            writer.append("$('#" + elementID + "').parent().remove()");
            writer.append("</script>");
        }
    }

    private void drawPie(Writer writer, Map<String, Integer> data, String elementID) throws IOException {
        List<PieSort> pieList = this.topX(data, 9);
        String dataVarName = "data_" + elementID;
        writer.append("<script type='text/javascript'>");
        writer.append(System.lineSeparator() + " WINDUP_PACKAGE_PIE_DATA = typeof(WINDUP_PACKAGE_PIE_DATA) == 'undefined' ? {} : WINDUP_PACKAGE_PIE_DATA;");
        writer.append(System.lineSeparator() + " WINDUP_PACKAGE_PIE_DATA['").append(elementID).append("'] = [];");
        for (PieSort p : pieList) {
            writer.append(System.lineSeparator() + " WINDUP_PACKAGE_PIE_DATA['").append(elementID).append("'].push({label: '" + p.label + "', data: ").append(p.value.toString()).append("});");
        }
        writer.append(System.lineSeparator() + " $(function () {");
        writer.append(System.lineSeparator() + "   var " + dataVarName + " = [];");
        for (PieSort p : pieList) {
            writer.append(System.lineSeparator() + " ").append(dataVarName).append(".push({ label: '").append(p.key).append("', data: ").append(p.value.toString()).append(" });");
        }
        writer.append(System.lineSeparator() + "   $.plot($('#" + elementID + "'), " + dataVarName + ", {");
        writer.append(System.lineSeparator() + "       series: { pie: { show: true,  innerRadius: 0.55, offset: { top: 0, left: -120 } } },");
        writer.append(System.lineSeparator() + "       colors: $.map( " + dataVarName + ", function(item, index) {" + System.lineSeparator() + "           var len = " + dataVarName + ".length;" + System.lineSeparator() + "           return jQuery.Color({" + System.lineSeparator() + "               hue: ((index*0.95*360/len) + 90/len) % 360," + System.lineSeparator() + "               saturation: 0.95," + System.lineSeparator() + "               lightness: ((index%4 == 3 ? 1:0)/-4)+0.55, alpha: 1" + System.lineSeparator() + "           }).toHexString();" + System.lineSeparator() + "       })");
        writer.append(System.lineSeparator() + "   });");
        writer.append(System.lineSeparator() + " });");
        writer.append("</script>");
    }

    public String getDirectiveName() {
        return NAME;
    }

    private List<PieSort> topX(Map<String, Integer> map, int top) {
        List<PieSort> list = new ArrayList<PieSort>(map.keySet().size() + 1);
        for (String key : map.keySet()) {
            PieSort p = new PieSort(key + " - " + map.get(key) + "&times;", key, map.get(key));
            list.add(p);
        }
        Collections.sort(list);
        if (top < list.size()) {
            int other = 0;
            for (PieSort p : list.subList(top, list.size())) {
                other += p.value.intValue();
            }
            list = list.subList(0, top);
            if (other > 0) {
                list.add(new PieSort("Other - " + other + "&times;", "Other", other));
            }
        }
        return list;
    }

    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }

    private static class PieSort
    implements Comparable<PieSort> {
        public final String key;
        public final String label;
        public final Integer value;

        PieSort(String k, String label, Integer v) {
            this.key = k;
            this.label = label;
            this.value = v;
        }

        @Override
        public int compareTo(PieSort p) {
            return p.value - this.value;
        }
    }
}

