/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import java.util.HashMap;
import javax.inject.Inject;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.AboutWindupModel;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.Theme;
import org.jboss.windup.util.ThemeProvider;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class)
public class CreateAboutWindupReportRuleProvider
extends AbstractRuleProvider {
    public static final String REPORT_DESCRIPTION = "This describes the version of %s used to generate this report and provides helpful links for further assistance.";
    public static final String REPORT_NAME = "About";
    public static final String TEMPLATE_APPLICATION_REPORT = "/reports/templates/about_windup.ftl";
    @Inject
    Addon addon;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        QueryBuilderFind windupConfigurationFound = Query.fromType(WindupConfigurationModel.class);
        AbstractIterationOperation<WindupConfigurationModel> addApplicationReport = new AbstractIterationOperation<WindupConfigurationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel payload) {
                CreateAboutWindupReportRuleProvider.this.createAboutWindup(event.getGraphContext(), null);
                for (FileModel inputPath : payload.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    if (projectModel == null) {
                        throw new WindupException("Error, no project found in: " + inputPath.getFilePath());
                    }
                    CreateAboutWindupReportRuleProvider.this.createAboutWindup(event.getGraphContext(), projectModel);
                }
            }

            public String toString() {
                return "CreateAboutWindupReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)windupConfigurationFound).perform((Operation)addApplicationReport);
    }

    private ApplicationReportModel createAboutWindup(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(10000);
        applicationReportModel.setReportName(REPORT_NAME);
        Theme theme = ThemeProvider.getInstance().getTheme();
        applicationReportModel.setDescription(String.format(REPORT_DESCRIPTION, theme.getBrandName()));
        applicationReportModel.setReportIconClass("fa fa-question-circle");
        applicationReportModel.setMainApplicationReport(Boolean.valueOf(false));
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        if (projectModel == null) {
            applicationReportModel.setDisplayInGlobalApplicationIndex(Boolean.valueOf(true));
        } else {
            applicationReportModel.setProjectModel(projectModel);
        }
        applicationReportModel.setTemplatePath(TEMPLATE_APPLICATION_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        HashMap<String, AboutWindupModel> related = new HashMap<String, AboutWindupModel>();
        AboutWindupModel aboutWindupModel = (AboutWindupModel)context.getFramed().addFramedVertex(AboutWindupModel.class);
        aboutWindupModel.setWindupRuntimeVersion(theme.getCliVersion());
        related.put("windupAbout", aboutWindupModel);
        applicationReportModel.setRelatedResource(related);
        ReportService reportService = new ReportService(context);
        String filename = projectModel == null ? "about_global" : "about_" + projectModel.getName();
        reportService.setUniqueFilename((ReportModel)applicationReportModel, filename, "html");
        return applicationReportModel;
    }
}

