/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.java.condition.SourceMode;
import org.jboss.windup.rules.apps.java.dependencyreport.DependenciesReportModel;
import org.jboss.windup.rules.apps.java.dependencyreport.DependencyReportDependencyGroupModel;
import org.jboss.windup.rules.apps.java.reporting.freemarker.dto.DependencyGraphItem;
import org.jboss.windup.rules.apps.java.reporting.freemarker.dto.DependencyGraphItemsAndRelations;
import org.jboss.windup.rules.apps.java.reporting.freemarker.dto.DependencyGraphRelation;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportRenderingPhase.class)
public class CreateDependencyGraphDataRuleProvider
extends AbstractRuleProvider {
    private static final String APP_DEPENDENCY_GRAPH_JS_FILENAME = "app_dependencies_graph.js";
    private static final String JS_DATA_FUNCTION_NAME = "app_dependencies";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)SourceMode.isDisabled()).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                CreateDependencyGraphDataRuleProvider.this.generateData(event);
            }
        });
    }

    private void generateData(GraphRewrite event) {
        GraphContext graphContext = event.getGraphContext();
        ReportService reportService = new ReportService(graphContext);
        List dependenciesReportModels = graphContext.service(DependenciesReportModel.class).findAll();
        dependenciesReportModels.stream().forEach(dependenciesReportModel -> {
            Path appDependencyGraphPath;
            ProjectModel application = dependenciesReportModel.getProjectModel();
            if (application != null && "VIRTUAL".equals(application.getProjectType())) {
                return;
            }
            Path dataDirectory = reportService.getReportDataDirectory();
            List<DependencyReportDependencyGroupModel> dependencyReportDependencyGroupModels = dependenciesReportModel.getArchiveGroups();
            HashMap<String, DependencyGraphItem> items = new HashMap<String, DependencyGraphItem>(dependencyReportDependencyGroupModels.size() + 1);
            ArrayList<DependencyGraphRelation> relations = new ArrayList<DependencyGraphRelation>(dependencyReportDependencyGroupModels.size());
            if (application != null) {
                DependencyGraphItem analyzedApplicationDependencyGraphItem = new DependencyGraphItem(dependenciesReportModel.getProjectModel());
                String applicationHash = this.getSha1Hash(application.getRootFileModel());
                items.put(applicationHash, analyzedApplicationDependencyGraphItem);
                appDependencyGraphPath = dataDirectory.resolve(applicationHash + "_app_dependencies_graph.js");
            } else {
                WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext()).getInputPaths().stream().filter(fileModel -> !"VIRTUAL".equals(fileModel.getProjectModel().getProjectType())).forEach(fileModel -> {
                    DependencyGraphItem analyzedApplicationDependencyGraphItem = new DependencyGraphItem(fileModel.getProjectModel());
                    String applicationHash = this.getSha1Hash((FileModel)fileModel);
                    items.put(applicationHash, analyzedApplicationDependencyGraphItem);
                });
                appDependencyGraphPath = dataDirectory.resolve(APP_DEPENDENCY_GRAPH_JS_FILENAME);
            }
            dependencyReportDependencyGroupModels.stream().forEach(dependencyReportDependencyGroupModel -> {
                DependencyGraphItem dependencyGraphItem = new DependencyGraphItem((DependencyReportDependencyGroupModel)dependencyReportDependencyGroupModel);
                items.put(dependencyReportDependencyGroupModel.getSHA1(), dependencyGraphItem);
                dependencyReportDependencyGroupModel.getArchives().stream().forEach(dependencyReportToArchiveEdgeModel -> {
                    ArchiveModel targetFileModel;
                    if (dependencyReportToArchiveEdgeModel.getArchive().getParentArchive() != null) {
                        targetFileModel = dependencyReportToArchiveEdgeModel.getArchive().getParentArchive();
                    } else {
                        targetFileModel = dependencyReportToArchiveEdgeModel.getArchive().getRootArchiveModel();
                        if (dependencyReportToArchiveEdgeModel.getArchive().equals(targetFileModel) && event.getGraphContext().getOptionMap().getOrDefault("explodedApp", Boolean.FALSE).booleanValue() && application != null) {
                            targetFileModel = application.getRootFileModel();
                        }
                    }
                    DependencyGraphRelation dependencyGraphRelation = new DependencyGraphRelation(dependencyReportDependencyGroupModel.getSHA1(), this.getSha1Hash((FileModel)targetFileModel));
                    relations.add(dependencyGraphRelation);
                });
            });
            DependencyGraphItemsAndRelations dependencyGraphItemsAndRelations = new DependencyGraphItemsAndRelations(items, relations);
            try (FileWriter dependencyGraphAppDependenciesWriter = new FileWriter(appDependencyGraphPath.toFile());){
                MappingJsonFactory jsonFactory = new MappingJsonFactory();
                jsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                ObjectMapper objectMapper = new ObjectMapper((JsonFactory)jsonFactory);
                objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                dependencyGraphAppDependenciesWriter.write("app_dependencies(");
                objectMapper.writer().writeValue((Writer)dependencyGraphAppDependenciesWriter, (Object)dependencyGraphItemsAndRelations);
                dependencyGraphAppDependenciesWriter.write(");");
                dependencyGraphAppDependenciesWriter.flush();
            }
            catch (IOException ioe) {
                throw new WindupException("Error serializing dependencies graph due to: " + ioe.getMessage(), (Throwable)ioe);
            }
        });
    }

    private String getSha1Hash(FileModel fileModel) {
        return !fileModel.isDirectory() ? fileModel.getSHA1Hash() : DigestUtils.sha1Hex((String)fileModel.getFileName());
    }
}

