/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import java.util.List;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.java.condition.SourceMode;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class)
public class CreateDependencyGraphReportRuleProvider
extends AbstractRuleProvider {
    public static final String REPORT_NAME = "Dependencies Graph";
    public static final String SINGLE_APPLICATION_REPORT_DESCRIPTION = "This graph shows the dependencies embedded within the analyzed application";
    public static final String GLOBAL_REPORT_DESCRIPTION = "This graph shows the dependencies embedded within the analyzed applications";
    public static final String TEMPLATE = "/reports/templates/dependency_graph.ftl";
    private static final String REPORT_BASEFILENAME = "dependency_graph_report";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)SourceMode.isDisabled()).perform((Operation)new CreateDependencyGraphReportOperation());
    }

    private class CreateDependencyGraphReportOperation
    extends GraphOperation {
        private CreateDependencyGraphReportOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            List inputPaths = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext()).getInputPaths();
            if (inputPaths.size() > 1) {
                this.createGlobalAppDependencyGraphReport(event.getGraphContext());
            }
            inputPaths.stream().filter(inputPath -> !"VIRTUAL".equals(inputPath.getProjectModel().getProjectType())).forEach(inputPath -> this.createSingleAppDependencyGraphReport(event.getGraphContext(), inputPath.getProjectModel()));
        }

        private ApplicationReportModel createAppDependencyGraphReport(GraphContext context) {
            ApplicationReportService applicationReportService = new ApplicationReportService(context);
            ApplicationReportModel report = applicationReportService.create();
            report.setReportPriority(104);
            report.setReportIconClass("glyphicon glyphicon-tree-deciduous");
            report.setTemplatePath(CreateDependencyGraphReportRuleProvider.TEMPLATE);
            report.setTemplateType(TemplateType.FREEMARKER);
            report.setDisplayInApplicationReportIndex(Boolean.TRUE);
            return report;
        }

        private void createSingleAppDependencyGraphReport(GraphContext context, ProjectModel projectModel) {
            ReportService reportService = new ReportService(context);
            ApplicationReportModel report = this.createAppDependencyGraphReport(context);
            report.setReportName(CreateDependencyGraphReportRuleProvider.REPORT_NAME);
            report.setProjectModel(projectModel);
            report.setMainApplicationReport(Boolean.FALSE);
            report.setDescription("This graph shows the dependencies embedded within the analyzed application.");
            reportService.setUniqueFilename((ReportModel)report, CreateDependencyGraphReportRuleProvider.REPORT_BASEFILENAME, "html");
        }

        private void createGlobalAppDependencyGraphReport(GraphContext context) {
            ReportService reportService = new ReportService(context);
            ApplicationReportModel report = this.createAppDependencyGraphReport(context);
            report.setReportName(CreateDependencyGraphReportRuleProvider.REPORT_NAME);
            report.setDisplayInGlobalApplicationIndex(Boolean.TRUE);
            report.setDescription("This graph shows the dependencies embedded within the analyzed applications.");
            reportService.setUniqueFilename((ReportModel)report, "dependency_graph_report_global", "html");
        }
    }
}

