/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.DependentPhase;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.OnlyOnceTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummaryService;
import org.jboss.windup.reporting.model.TechnologyUsageStatisticsModel;
import org.jboss.windup.reporting.rules.AttachApplicationReportsToIndexRuleProvider;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DependentPhase.class, after={PostReportGenerationPhase.class}, before={AttachApplicationReportsToIndexRuleProvider.class}, haltOnException=true)
public class CreateJsonSummaryRuleProvider
extends AbstractRuleProvider {
    private static final Set<String> DISCARDED_TAGS = new HashSet<String>(Arrays.asList("Java EE", "Embedded", "View", "Connect", "Store", "Sustain", "Execute"));

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(WindupConfigurationModel.class).withProperty("exportSummary", (Object)true)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                CreateJsonSummaryRuleProvider.this.generateDataSummary(event);
            }
        });
    }

    private void generateDataSummary(GraphRewrite event) {
        try {
            WindupConfigurationModel windupConfiguration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
            ArrayList<Object> analysisSummaryList = new ArrayList<Object>();
            for (FileModel inputApplicationFile : windupConfiguration.getInputPaths()) {
                ProjectModel inputApplication = inputApplicationFile.getProjectModel();
                ProjectModelTraversal projectModelTraversal = new ProjectModelTraversal(inputApplication, (TraversalStrategy)new OnlyOnceTraversalStrategy());
                Map<String, List<ProblemSummary>> summariesBySeverity = ProblemSummaryService.getProblemSummaries((GraphContext)event.getGraphContext(), (Set)projectModelTraversal.getAllProjects(true), Collections.emptySet(), Collections.emptySet()).entrySet().stream().collect(Collectors.toMap(e -> ((IssueCategoryModel)e.getKey()).getCategoryID(), Map.Entry::getValue));
                analysisSummaryList.add(this.writeApplicationExportSummary(summariesBySeverity, inputApplicationFile, event.getGraphContext()));
            }
            this.writeJsonOutputFile(analysisSummaryList, windupConfiguration);
        }
        catch (Exception e2) {
            throw new WindupException("Error serializing problem details due to: " + e2.getMessage(), (Throwable)e2);
        }
    }

    private Map<String, Object> writeApplicationExportSummary(Map<String, List<ProblemSummary>> summariesBySeverity, FileModel application, GraphContext context) {
        HashMap translatedResults = new HashMap();
        summariesBySeverity.forEach((k, v) -> {
            int incidents = 0;
            int effortPoints = 0;
            for (ProblemSummary summary : v) {
                incidents += summary.getNumberFound();
                effortPoints += summary.getNumberFound() * summary.getEffortPerIncident();
            }
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            results.put("incidents", incidents);
            results.put("totalStoryPoints", effortPoints);
            translatedResults.put(k, results);
        });
        LinkedHashMap<String, Object> resultsWithTitle = new LinkedHashMap<String, Object>();
        resultsWithTitle.put("application", application.getFileName());
        resultsWithTitle.put("incidentsByCategory", translatedResults);
        List<ProblemSummary> mandatorySummaries = summariesBySeverity.get("mandatory");
        HashMap<Integer, Integer> incidentsByEffort = new HashMap<Integer, Integer>();
        if (mandatorySummaries != null) {
            mandatorySummaries.forEach(ps -> {
                if (!incidentsByEffort.containsKey(ps.getEffortPerIncident())) {
                    incidentsByEffort.put(ps.getEffortPerIncident(), ps.getNumberFound());
                } else {
                    incidentsByEffort.replace(ps.getEffortPerIncident(), (Integer)incidentsByEffort.get(ps.getEffortPerIncident()) + ps.getNumberFound());
                }
            });
        }
        HashMap translatedEffortResults = new HashMap();
        incidentsByEffort.forEach((k, v) -> {
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            results.put("incidents", (Integer)v);
            results.put("totalStoryPoints", k * v);
            translatedEffortResults.put(this.getEffortDescription((Integer)k), results);
        });
        resultsWithTitle.put("mandatoryIncidentsByType", translatedEffortResults);
        resultsWithTitle.put("technologyTags", this.getTechnologyTagsForApplication(application, context));
        return resultsWithTitle;
    }

    private void writeJsonOutputFile(List<Object> analysisSummary, WindupConfigurationModel windupConfig) {
        String outputFolderPath = windupConfig.getOutputPath().getFilePath() + File.separator + "analysisSummary.json";
        ObjectMapper mapper = new ObjectMapper();
        try (FileWriter writer = new FileWriter(outputFolderPath);){
            String json = mapper.writeValueAsString(analysisSummary);
            writer.write(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Couldn't convert given map to JSON: " + e.getMessage());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't write summary to file: " + ioe.getMessage());
        }
    }

    private Set<Map<String, String>> getTechnologyTagsForApplication(FileModel application, GraphContext context) {
        GraphService service = new GraphService(context, TechnologyUsageStatisticsModel.class);
        return service.findAll().stream().filter(technologyUsageStatisticsModel -> application.getProjectModel().equals(technologyUsageStatisticsModel.getProjectModel().getRootProjectModel())).map(technologyUsageStatisticsModel -> {
            HashMap<String, String> techTag = new HashMap<String, String>(2);
            techTag.put("name", technologyUsageStatisticsModel.getName());
            techTag.put("category", technologyUsageStatisticsModel.getTags().stream().filter(technologyName -> !DISCARDED_TAGS.contains(technologyName)).findFirst().orElse("Other"));
            return techTag;
        }).collect(Collectors.toCollection(() -> new TreeSet<Map>(Comparator.comparing(stringStringMap -> (String)stringStringMap.get("name")))));
    }

    private String getEffortDescription(Integer effort) {
        switch (effort) {
            case 0: {
                return "Info";
            }
            case 1: {
                return "Trivial";
            }
            case 3: {
                return "Complex";
            }
            case 5: {
                return "Redesign";
            }
            case 7: {
                return "Architectural";
            }
        }
        return "Unknown";
    }
}

