/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.Importer;
import org.jboss.forge.roaster.spi.WildcardImportResolver;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;

public class WindupWildcardImportResolver
implements WildcardImportResolver,
org.jboss.windup.ast.java.WildcardImportResolver {
    private static GraphContext context;
    private final Map<String, String> classNameToFQCN = new ConcurrentHashMap<String, String>();
    private final Set<String> classNameLookedUp = Collections.synchronizedSet(new HashSet());

    public String resolve(JavaType<?> source, String type) {
        GraphContext graphContext = this.getContext();
        if (graphContext == null) {
            return type;
        }
        Importer importer = (Importer)source;
        ArrayList<String> wildcardImports = new ArrayList<String>();
        for (Import importDeclaration : importer.getImports()) {
            if (!importDeclaration.isWildcard()) continue;
            wildcardImports.add(importDeclaration.getQualifiedName());
        }
        return this.resolve(wildcardImports, type);
    }

    public String resolve(List<String> wildcardImports, String type) {
        GraphContext graphContext = this.getContext();
        if (this.classNameLookedUp.contains(type)) {
            String qualifiedName = this.classNameToFQCN.get(type);
            if (qualifiedName != null) {
                return qualifiedName;
            }
            return type;
        }
        this.classNameLookedUp.add(type);
        Iterator<String> iterator = wildcardImports.iterator();
        while (iterator.hasNext()) {
            JavaClassService javaClassService = new JavaClassService(graphContext);
            String wildcardImport = iterator.next();
            String candidateQualifiedName = wildcardImport + "." + type;
            Iterable models = javaClassService.findAllByProperty("qualifiedName", candidateQualifiedName);
            if (!models.iterator().hasNext()) continue;
            this.classNameToFQCN.put(type, candidateQualifiedName);
            return candidateQualifiedName;
        }
        return type;
    }

    public String[] resolve(String wildcardImportPackageName) {
        JavaClassService javaClassService = new JavaClassService(this.getContext());
        Iterable<JavaClassModel> classModels = javaClassService.findByJavaPackage(wildcardImportPackageName);
        ArrayList<String> results = new ArrayList<String>();
        for (JavaClassModel classModel : classModels) {
            results.add(classModel.getQualifiedName());
        }
        return results.toArray(new String[results.size()]);
    }

    private GraphContext getContext() {
        return context;
    }

    public static void setContext(GraphContext context) {
        WindupWildcardImportResolver.context = context;
    }
}

