/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.File;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class RecurseDirectoryAndAddFiles
extends AbstractIterationOperation<FileModel> {
    public String toString() {
        return "RecurseDirectoryAndAddFiles";
    }

    public void perform(GraphRewrite event, EvaluationContext context, FileModel resourceModel) {
        FileService fileModelService = new FileService(event.getGraphContext());
        WindupJavaConfigurationService javaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
        this.recurseAndAddFiles(event, fileModelService, javaConfigurationService, resourceModel);
    }

    private void recurseAndAddFiles(GraphRewrite event, FileService fileService, WindupJavaConfigurationService javaConfigurationService, FileModel file) {
        if (javaConfigurationService.checkRegexAndIgnore(event, file)) {
            return;
        }
        String filePath = file.getFilePath();
        File fileReference = new File(filePath);
        long directorySize = 0L;
        if (fileReference.isDirectory()) {
            File[] subFiles = fileReference.listFiles();
            if (subFiles != null) {
                for (File reference : subFiles) {
                    if (javaConfigurationService.isTargetDir(file)) continue;
                    FileModel subFile = fileService.createByFilePath(file, reference.getAbsolutePath());
                    this.recurseAndAddFiles(event, fileService, javaConfigurationService, subFile);
                    if (subFile.isDirectory()) {
                        directorySize += subFile.getDirectorySize().longValue();
                        continue;
                    }
                    directorySize += subFile.getSize().longValue();
                }
            }
            file.setDirectorySize(Long.valueOf(directorySize));
        }
    }
}

