/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation.packagemapping;

import java.util.List;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphListener;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.IgnoredArchiveModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.ArchiveService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.util.Logging;

public class ArchivePackageNameIdentificationGraphChangedListener
implements GraphListener {
    private static Logger LOG = Logging.get(ArchivePackageNameIdentificationGraphChangedListener.class);
    private GraphRewrite event;

    public ArchivePackageNameIdentificationGraphChangedListener(GraphRewrite event) {
        this.event = event;
    }

    public void vertexPropertyChanged(Vertex vertex, Property property, Object oldValue, Object ... setValue) {
        try {
            if ("archiveName".equals(property.key())) {
                ArchiveService archiveService = new ArchiveService(this.event.getGraphContext());
                ArchiveModel archive = (ArchiveModel)archiveService.getById(vertex.id());
                if (archive instanceof IgnoredArchiveModel || archive instanceof IdentifiedArchiveModel) {
                    return;
                }
                WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)this.event.getGraphContext());
                if (cfg.isAnalyzeKnownLibraries().booleanValue()) {
                    return;
                }
                if (this.allPackagesAreKnown(archive)) {
                    IgnoredFileModel ignoredFileModel = (IgnoredFileModel)new GraphService(this.event.getGraphContext(), IgnoredFileModel.class).addTypeToModel((WindupVertexFrame)archive);
                    ignoredFileModel.setIgnoredRegex("3rd Party Archive");
                    new GraphService(this.event.getGraphContext(), IdentifiedArchiveModel.class).addTypeToModel((WindupVertexFrame)archive);
                }
            }
        }
        catch (Throwable t) {
            LOG.warning("Failed to check package name mapping due to: " + t.getMessage());
        }
    }

    private boolean allPackagesAreKnown(ArchiveModel archive) {
        boolean allPackagesAreKnown = PackageNameMapping.areAllPackagesKnown(this.event, archive.getFilePath());
        List inputPaths = WindupConfigurationService.getConfigurationModel((GraphContext)this.event.getGraphContext()).getInputPaths();
        allPackagesAreKnown = allPackagesAreKnown && inputPaths.stream().noneMatch(inputPath -> inputPath.equals(archive));
        return allPackagesAreKnown;
    }

    public void vertexAdded(Vertex vertex) {
    }
}

