/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation.packagemapping;

import java.nio.file.Path;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.util.PathUtil;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleVisit;

public class PackageNameMappingRegistry {
    private static final Logger LOG = Logger.getLogger(PackageNameMappingRegistry.class.getName());
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private RuleProviderRegistryCache cache;
    private GraphRewrite event;

    public String getOrganizationForPackage(String packageName) {
        return PackageNameMapping.getOrganizationFromMappings(this.event, packageName);
    }

    public void loadPackageMappings() {
        this.loadPackageMappings(PathUtil.getWindupRulesDir());
    }

    public void loadPackageMappings(Path rulesPath) {
        try (GraphContext graphContext = this.graphContextFactory.create(false);){
            WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
            FileModel windupRulesPath = new FileService(graphContext).createByFilePath(rulesPath.toString());
            configurationModel.addUserRulesPath(windupRulesPath);
            RuleLoaderContext ruleLoaderContext = new RuleLoaderContext(Collections.singleton(rulesPath), null);
            RuleProviderRegistry registry = this.cache.getRuleProviderRegistry(ruleLoaderContext);
            this.event = new GraphRewrite(graphContext);
            RuleSubset ruleSubset = RuleSubset.create((Configuration)registry.getConfiguration());
            new RuleVisit((Rule)ruleSubset).accept(r -> {
                if (r instanceof PackageNameMapping) {
                    ((PackageNameMapping)r).preRulesetEvaluation(this.event);
                }
            });
            graphContext.clear();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load rule information due to: " + e.getMessage(), e);
        }
    }
}

