/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.phase.PostFinalizePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.WindupConfigurationQuery;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.scan.operation.DeleteWorkDirsOperation;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Not;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(afterIDs={"CreateRuleProviderReportRuleProvider"}, description="Deletes the temporary data the CLI analyzes: the unzipped archives, and the graph data. Use --keepWorkDirs to keep them.", phase=PostFinalizePhase.class)
public class DeleteWorkDirsAtTheEndRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Not.any((Condition)WindupConfigurationQuery.hasOption((String)"keepWorkDirs", (Object)true).as("discard")), new Condition[]{Query.fromType(ArchiveModel.class).withProperty("unzippedDirectory").as("archives")}).perform((Operation)Iteration.over((String)"archives").perform(new Operation[]{DeleteWorkDirsOperation.delete(), IterationProgress.monitoring((String)"Deleted archive unzip directory", (int)1)}).endIteration()).addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                File archivesDir = WindupConfigurationService.getArchivesPath((GraphContext)event.getGraphContext()).toFile();
                if (archivesDir.exists() && archivesDir.isDirectory() && archivesDir.list().length == 0) {
                    archivesDir.delete();
                }
            }

            public String toString() {
                return "Delete archives directory if empty";
            }
        });
    }
}

