/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.DuplicateProjectModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.graph.service.Service;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverMavenHierarchyRuleProvider;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DiscoverProjectStructurePhase.class, after={DiscoverMavenHierarchyRuleProvider.class})
public class DiscoverDuplicateArchiveProjectsRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(DuplicateArchiveModel.class)).perform((Operation)new AbstractIterationOperation<DuplicateArchiveModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, DuplicateArchiveModel payload) {
                DiscoverDuplicateArchiveProjectsRuleProvider.this.setupProject(event, payload);
            }
        });
    }

    private void setupProject(GraphRewrite event, DuplicateArchiveModel duplicateArchive) {
        Service duplicateProjectService = event.getGraphContext().service(DuplicateProjectModel.class);
        ArchiveModel canonicalArchive = duplicateArchive.getCanonicalArchive();
        ProjectModel canonicalProject = canonicalArchive.getProjectModel();
        DuplicateProjectModel duplicateProject = (DuplicateProjectModel)duplicateProjectService.create();
        duplicateProject.setCanonicalProject(canonicalProject);
        duplicateProject.setName(canonicalProject.getName());
        if (duplicateArchive.getParentArchive() != null) {
            duplicateProject.setParentProject(duplicateArchive.getParentArchive().getProjectModel());
        }
        duplicateProject.setRootFileModel((FileModel)duplicateArchive);
        if (canonicalProject.getParentProject() == null) {
            ProjectService projectService = new ProjectService(event.getGraphContext());
            ProjectModel sharedLibsProject = projectService.getOrCreateSharedLibsProject();
            canonicalProject.setParentProject(sharedLibsProject);
        }
        duplicateProject.addFileModel((FileModel)duplicateArchive);
    }
}

