/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderWith;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.DependencyLocation;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.IgnoredArchiveModel;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.rules.apps.java.scan.provider.MavenProjectDependencyLocationExtractor;
import org.jboss.windup.rules.apps.maven.dao.MavenProjectService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.MarshallingException;
import org.jboss.windup.util.xml.XmlUtil;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RuleMetadata(phase=DiscoverProjectStructurePhase.class, haltOnException=true)
public class DiscoverMavenProjectsRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(DiscoverMavenProjectsRuleProvider.class);
    private static final Map<String, String> namespaces = new HashMap<String, String>();
    private final MavenElementValueResolver mavenElementValueResolver = new MavenElementValueResolver();
    private final MavenProjectDependencyLocationExtractor mavenProjectDependencyLocationExtractor = new MavenProjectDependencyLocationExtractor();

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        QueryBuilderWith fileWhen = Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"pom.xml");
        AbstractIterationOperation<XmlFileModel> evaluatePomFiles = new AbstractIterationOperation<XmlFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
                block4: {
                    MavenProjectModel mavenProjectModel;
                    block5: {
                        ArchiveModel archiveModel;
                        if (payload.getProjectModel() != null) {
                            return;
                        }
                        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
                        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
                        String defaultName = payload.getArchive() == null ? payload.asFile().getParentFile().getName() : payload.getArchive().getFileName();
                        mavenProjectModel = DiscoverMavenProjectsRuleProvider.this.extractMavenProjectModel(event, context, defaultName, payload);
                        if (mavenProjectModel == null) break block4;
                        if (!(payload.getArchive() instanceof IgnoredArchiveModel)) {
                            classificationService.attachClassification(event, context, (FileModel)payload, "information", "Maven POM (pom.xml)", "Maven Project Object Model (POM) File");
                            technologyTagService.addTagToFileModel((FileModel)payload, "Maven XML", TechnologyTagLevel.INFORMATIONAL);
                        }
                        if ((archiveModel = payload.getArchive()) == null || DiscoverMavenProjectsRuleProvider.this.isAlreadyMavenProject((FileModel)archiveModel)) break block5;
                        mavenProjectModel.addFileModel((FileModel)archiveModel);
                        mavenProjectModel.setRootFileModel((FileModel)archiveModel);
                        for (FileModel f : archiveModel.getAllFiles()) {
                            if (f instanceof ArchiveModel || f.getProjectModel() != null) continue;
                            mavenProjectModel.addFileModel(f);
                        }
                        break block4;
                    }
                    File parentFile = payload.asFile().getParentFile();
                    FileModel parentFileModel = new FileService(event.getGraphContext()).findByPath(parentFile.getAbsolutePath());
                    if (parentFileModel == null || DiscoverMavenProjectsRuleProvider.this.isAlreadyMavenProject(parentFileModel)) break block4;
                    mavenProjectModel.addFileModel(parentFileModel);
                    mavenProjectModel.setRootFileModel(parentFileModel);
                    for (FileModel childFile : parentFileModel.getFilesInDirectory()) {
                        DiscoverMavenProjectsRuleProvider.this.addFilesToModel(mavenProjectModel, childFile);
                    }
                }
            }

            public String toString() {
                return "ScanMavenProject";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)fileWhen).perform((Operation)evaluatePomFiles);
    }

    private boolean isAlreadyMavenProject(FileModel fileModel) {
        return fileModel.getProjectModel() != null && fileModel.getProjectModel() instanceof MavenProjectModel;
    }

    private void addFilesToModel(MavenProjectModel mavenProjectModel, FileModel fileModel) {
        for (Object childFile : fileModel.getFilesInDirectory()) {
            String filename = childFile.getFileName();
            if (!filename.equals("pom.xml")) continue;
            return;
        }
        if (fileModel instanceof ArchiveModel) {
            ArchiveModel childArchive = (ArchiveModel)fileModel;
            if (childArchive instanceof DuplicateArchiveModel) {
                childArchive = ((DuplicateArchiveModel)childArchive).getCanonicalArchive();
            }
            if (childArchive instanceof IgnoredArchiveModel || childArchive instanceof IdentifiedArchiveModel) {
                return;
            }
            for (FileModel archiveChild : childArchive.getAllFiles()) {
                String filename = archiveChild.getFileName();
                if (!filename.equals("pom.xml")) continue;
                return;
            }
        }
        mavenProjectModel.addFileModel(fileModel);
        for (Object childFile : fileModel.getFilesInDirectory()) {
            this.addFilesToModel(mavenProjectModel, (FileModel)childFile);
        }
    }

    public MavenProjectModel extractMavenProjectModel(GraphRewrite event, EvaluationContext context, String defaultProjectName, XmlFileModel xmlFileModel) {
        MavenProjectService mavenProjectService;
        MavenProjectModel mavenProjectModel;
        Document document;
        try {
            document = new XmlFileService(event.getGraphContext()).loadDocument(event, context, xmlFileModel);
        }
        catch (Exception ex) {
            xmlFileModel.setParseError("Could not parse POM XML: " + ex.getMessage());
            LOG.warning("Could not parse POM XML for '" + xmlFileModel.getFilePath() + "':" + System.lineSeparator() + "\t" + ex.getMessage() + System.lineSeparator() + " \tSkipping Maven project discovery.");
            return null;
        }
        String modelVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:modelVersion | /project/modelVersion", namespaces);
        String name = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:name | /project/name", namespaces);
        String organization = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:organization | /project/organization", namespaces);
        String description = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:description | /project/description", namespaces);
        String url = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:url | /project/url", namespaces);
        String groupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:groupId | /project/groupId", namespaces);
        String artifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:artifactId | /project/artifactId", namespaces);
        String version = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:version | /project/version", namespaces);
        String parentGroupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:groupId | /project/parent/groupId", namespaces);
        String parentArtifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:artifactId | /project/parent/artifactId", namespaces);
        String parentVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:version | /project/parent/version", namespaces);
        if (StringUtils.isBlank((CharSequence)groupId) && StringUtils.isNotBlank((CharSequence)parentGroupId)) {
            groupId = parentGroupId;
        }
        if (StringUtils.isBlank((CharSequence)version) && StringUtils.isNotBlank((CharSequence)parentVersion)) {
            version = parentVersion;
        }
        if (StringUtils.isBlank((CharSequence)organization)) {
            organization = PackageNameMapping.getOrganizationFromMappings(event, groupId);
        }
        if ((mavenProjectModel = this.getMavenStubProject(mavenProjectService = new MavenProjectService(event.getGraphContext()), groupId, artifactId, version)) == null) {
            LOG.info("Creating maven project for pom at: " + xmlFileModel.getFilePath() + " with gav: " + groupId + "," + artifactId + "," + version);
            mavenProjectModel = mavenProjectService.createMavenStub(groupId, artifactId, version);
            mavenProjectModel.addMavenPom(xmlFileModel);
        } else {
            boolean found = false;
            for (XmlFileModel foundPom : mavenProjectModel.getMavenPom()) {
                File foundPomFile = foundPom.asFile();
                File pomXmlFile = xmlFileModel.asFile();
                if (!foundPomFile.getAbsoluteFile().equals(pomXmlFile)) continue;
                found = true;
                break;
            }
            if (!found) {
                mavenProjectModel.addMavenPom(xmlFileModel);
            }
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = defaultProjectName;
        }
        mavenProjectModel.setName(this.getReadableNameForProject(name, groupId, artifactId, version));
        if (StringUtils.isNotBlank((CharSequence)organization)) {
            mavenProjectModel.setOrganization(organization);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            mavenProjectModel.setDescription(StringUtils.trim((String)description));
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            mavenProjectModel.setURL(StringUtils.trim((String)url));
        }
        if (StringUtils.isNotBlank((CharSequence)modelVersion)) {
            mavenProjectModel.setSpecificationVersion(modelVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)parentGroupId)) {
            MavenProjectModel parent = this.getMavenProject(mavenProjectService, parentGroupId = this.mavenElementValueResolver.resolveValue(document, namespaces, parentGroupId, version), parentArtifactId = this.mavenElementValueResolver.resolveValue(document, namespaces, parentArtifactId, version), parentVersion = this.mavenElementValueResolver.resolveValue(document, namespaces, parentVersion, version));
            if (parent == null) {
                parent = mavenProjectService.createMavenStub(parentGroupId, parentArtifactId, parentVersion);
                parent.setName(this.getReadableNameForProject(null, parentGroupId, parentArtifactId, parentVersion));
            }
            mavenProjectModel.setParentMavenPOM(parent);
        }
        for (String xpath : this.getDependenciesXpath()) {
            NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)xpath, namespaces);
            int j = nodes.getLength();
            for (int i = 0; i < j; ++i) {
                Node node = nodes.item(i);
                String dependencyGroupId = XmlUtil.xpathExtract((Node)node, (String)"./pom:groupId | ./groupId", namespaces);
                String dependencyArtifactId = XmlUtil.xpathExtract((Node)node, (String)"./pom:artifactId | ./artifactId", namespaces);
                String dependencyVersion = XmlUtil.xpathExtract((Node)node, (String)"./pom:version | ./version", namespaces);
                String dependencyClassifier = XmlUtil.xpathExtract((Node)node, (String)"./pom:classifier | ./classifier", namespaces);
                String dependencyScope = XmlUtil.xpathExtract((Node)node, (String)"./pom:scope | ./scope", namespaces);
                String dependencyType = XmlUtil.xpathExtract((Node)node, (String)"./pom:type | ./type", namespaces);
                String dependencyOptional = XmlUtil.xpathExtract((Node)node, (String)"./pom:optional | ./optional", namespaces);
                dependencyGroupId = this.mavenElementValueResolver.resolveValue(document, namespaces, dependencyGroupId, version);
                dependencyArtifactId = this.mavenElementValueResolver.resolveValue(document, namespaces, dependencyArtifactId, version);
                dependencyVersion = this.mavenElementValueResolver.resolveValue(document, namespaces, dependencyVersion, version);
                if (!StringUtils.isNotBlank((CharSequence)dependencyGroupId) || Boolean.parseBoolean(dependencyOptional)) continue;
                MavenProjectModel dependency = this.getMavenProject(mavenProjectService, dependencyGroupId, dependencyArtifactId, dependencyVersion);
                if (dependency == null) {
                    dependency = mavenProjectService.createMavenStub(dependencyGroupId, dependencyArtifactId, dependencyVersion);
                    dependency.setName(this.getReadableNameForProject(null, dependencyGroupId, dependencyArtifactId, dependencyVersion));
                }
                DependencyLocation dependencyLocation = this.mavenProjectDependencyLocationExtractor.extractDependencyLocation(node);
                ProjectDependencyModel projectDep = (ProjectDependencyModel)new GraphService(event.getGraphContext(), ProjectDependencyModel.class).create();
                projectDep.setClassifier(dependencyClassifier);
                projectDep.setScope(dependencyScope);
                projectDep.setType(dependencyType);
                projectDep.setProject((ProjectModel)dependency);
                projectDep.setDependencyLocation(dependencyLocation);
                List<FileLocationModel> fileLocationList = this.extractFileLocations(event, xmlFileModel, node);
                projectDep.setFileLocationReference(fileLocationList);
                mavenProjectModel.addDependency(projectDep);
            }
        }
        return mavenProjectModel;
    }

    private List<String> getDependenciesXpath() {
        String parent = "/pom:project/pom:parent | /project/parent";
        String dependencies = "/pom:project/pom:dependencies/pom:dependency  | /project/dependencies/dependency | /pom:project/pom:profiles/pom:profile/pom:dependencies/pom:dependency  | /project/profiles/profile/dependencies/dependency";
        String pluginDependencies = "/pom:project/pom:build/pom:plugins/pom:plugin | /project/build/plugins/plugin    | /pom:project/pom:profiles/pom:profile/pom:build/pom:plugins/pom:plugin | /project/profiles/profile/build/plugins/plugin";
        String dependencyManagement = "/pom:project/pom:dependencyManagement/pom:dependencies/pom:dependency | /project/dependencyManagement/dependencies/dependency | /pom:project/pom:profiles/pom:profile/pom:dependencyManagement/pom:dependencies/pom:dependency | /project/profiles/profile/dependencyManagement/dependencies/dependency";
        String pluginManagement = "/pom:project/pom:build/pom:pluginManagement/pom:plugins/pom:plugin    | /project/build/pluginManagement/plugins/plugin        | /pom:project/pom:profiles/pom:profile/pom:build/pom:pluginManagement/pom:plugins/pom:plugin    | /project/profiles/profile/build/pluginManagement/plugins/plugin";
        return Arrays.asList(parent, dependencies, pluginDependencies, dependencyManagement, pluginManagement);
    }

    private List<FileLocationModel> extractFileLocations(GraphRewrite event, XmlFileModel xmlFileModel, Node node) {
        int lineNumber = (Integer)node.getUserData("ln");
        int columnNumber = (Integer)node.getUserData("cn");
        FileLocationModel fileLocation = (FileLocationModel)new GraphService(event.getGraphContext(), FileLocationModel.class).create();
        String sourceSnippet = XmlUtil.nodeToString((Node)node);
        fileLocation.setSourceSnippit(sourceSnippet);
        fileLocation.setLineNumber(lineNumber);
        fileLocation.setColumnNumber(columnNumber);
        fileLocation.setLength(node.toString().length());
        fileLocation.setFile((FileModel)xmlFileModel);
        ArrayList<FileLocationModel> fileLocationList = new ArrayList<FileLocationModel>(1);
        fileLocationList.add(fileLocation);
        return fileLocationList;
    }

    private MavenProjectModel getMavenProject(MavenProjectService mavenProjectService, String groupId, String artifactId, String version) {
        Iterable<MavenProjectModel> possibleProjects = mavenProjectService.findByGroupArtifactVersion(groupId, artifactId, version);
        MavenProjectModel project = null;
        for (MavenProjectModel possibleProject : possibleProjects) {
            if (possibleProject.getRootFileModel() != null) {
                return possibleProject;
            }
            if (project != null) continue;
            project = possibleProject;
        }
        return project;
    }

    private MavenProjectModel getMavenStubProject(MavenProjectService mavenProjectService, String groupId, String artifactId, String version) {
        Iterable<MavenProjectModel> mavenProjectModels = mavenProjectService.findByGroupArtifactVersion(groupId, artifactId, version);
        if (!mavenProjectModels.iterator().hasNext()) {
            return null;
        }
        for (MavenProjectModel mavenProjectModel : mavenProjectModels) {
            if (mavenProjectModel.getRootFileModel() != null) continue;
            return mavenProjectModel;
        }
        return null;
    }

    private String getReadableNameForProject(String mavenName, String groupId, String artifactId, String version) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)mavenName)) {
            sb.append(mavenName);
        } else if (StringUtils.isNotBlank((CharSequence)groupId) || StringUtils.isNotBlank((CharSequence)artifactId) || StringUtils.isNotBlank((CharSequence)version)) {
            sb.append(groupId).append(":").append(artifactId).append(":").append(version);
        }
        return sb.toString();
    }

    static {
        namespaces.put("pom", "http://maven.apache.org/POM/4.0.0");
    }

    static class MavenElementValueResolver {
        MavenElementValueResolver() {
        }

        String resolveValue(Document doc, Map<String, String> namespaces, String value, String projectVersion) throws MarshallingException {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '$' && value.charAt(i + 1) == '{') {
                    StringBuilder propertyName = new StringBuilder();
                    i += 2;
                    while (value.charAt(i) != '}') {
                        propertyName.append(value.charAt(i));
                        ++i;
                    }
                    String propertyValue = this.resolveProperty(doc, namespaces, propertyName.toString(), projectVersion);
                    result.append(propertyValue);
                    continue;
                }
                result.append(value.charAt(i));
            }
            return result.toString();
        }

        private String resolveProperty(Document doc, Map<String, String> namespaces, String name, String projectVersion) {
            switch (name) {
                case "pom.version": 
                case "project.version": {
                    return projectVersion;
                }
            }
            NodeList nodes = XmlUtil.xpathNodeList((Node)doc, (String)("//pom:properties/pom:" + name + " | //properties/" + name), namespaces);
            if (nodes.getLength() != -1 && nodes.item(0) != null) {
                Node node = nodes.item(-1);
                return node.getTextContent();
            }
            LOG.warning("Expected: " + name + " but it wasn't found in the POM.");
            return name;
        }
    }
}

