/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.ClassifyFileTypesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.PropertiesModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ClassifyFileTypesPhase.class, perform="Discover Properties Files")
public class DiscoverPropertiesFilesRuleProvider
extends IteratingRuleProvider<FileModel> {
    private static final String TECH_TAG = "Properties";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public ConditionBuilder when() {
        return Query.fromType(FileModel.class).withProperty("isDirectory", (Object)false).withProperty("filePath", QueryPropertyComparisonType.REGEX, (Object)".*\\.properties$");
    }

    public void perform(GraphRewrite event, EvaluationContext context, FileModel payload) {
        if (new WindupJavaConfigurationService(event.getGraphContext()).checkRegexAndIgnore(event, payload)) {
            return;
        }
        ExecutionStatistics.get().begin("DiscoverPropertiesFilesRuleProvider.perform");
        GraphService service = new GraphService(event.getGraphContext(), PropertiesModel.class);
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        PropertiesModel properties = (PropertiesModel)service.addTypeToModel((WindupVertexFrame)payload);
        properties.setGenerateSourceReport(true);
        GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, SourceFileModel.class);
        technologyTagService.addTagToFileModel(payload, TECH_TAG, TECH_TAG_LEVEL);
        ExecutionStatistics.get().end("DiscoverPropertiesFilesRuleProvider.perform");
    }
}

