/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.ast.java.data.ResolutionStatus;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.DependentPhase;
import org.jboss.windup.config.phase.PostMigrationRulesPhase;
import org.jboss.windup.config.phase.PreReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.config.HasHint;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DependentPhase.class, after={PostMigrationRulesPhase.class}, before={PreReportGenerationPhase.class}, tags={"java"})
public class FindUnboundJavaReferencesRuleProvider
extends AbstractRuleProvider {
    public static final String JAVA = "java";
    public static final String RULE_ID = FindUnboundJavaReferencesRuleProvider.class.getSimpleName();
    public static final String TITLE = "Unresolved Class Binding";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(WindupJavaConfigurationModel.class).withProperty("classNotFoundAnalysisEnabled", (Object)true)).perform((Operation)new AttachHintOperation()).withId(RULE_ID);
    }

    private class AttachHintOperation
    extends GraphOperation {
        private AttachHintOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            HasHint hasHint = new HasHint();
            GraphTraversal pipeline = new GraphTraversalSource((Graph)event.getGraphContext().getGraph()).V(new Object[0]).has("w:winduptype", (Object)"JavaTypeReferenceModel").has("resolutionStatus", P.neq((Object)ResolutionStatus.RESOLVED));
            GraphService typeReferenceService = new GraphService(event.getGraphContext(), JavaTypeReferenceModel.class);
            int count = 0;
            for (Vertex vertex : pipeline.toList()) {
                JavaTypeReferenceModel typeReference = (JavaTypeReferenceModel)typeReferenceService.frame(vertex);
                if (hasHint.evaluate(event, context, (WindupVertexFrame)typeReference)) continue;
                InlineHintModel hint = (InlineHintModel)new InlineHintService(event.getGraphContext()).create();
                hint.setRuleID(RULE_ID);
                hint.setLineNumber(typeReference.getLineNumber());
                hint.setColumnNumber(typeReference.getColumnNumber());
                hint.setLength(typeReference.getLength());
                hint.setFileLocationReference((FileLocationModel)typeReference);
                hint.setFile((FileModel)typeReference.getFile());
                hint.setEffort(5);
                IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance((Context)event.getRewriteContext());
                hint.setIssueCategory(IssueCategoryRegistry.loadFromGraph((GraphContext)event.getGraphContext(), (String)"mandatory"));
                hint.setTitle(FindUnboundJavaReferencesRuleProvider.TITLE);
                hint.setHint("This class reference (" + typeReference.getDescription() + ") could not be found on the classpath");
                typeReference.getFile().setGenerateSourceReport(true);
                if (++count % 1000 != 0) continue;
                event.getGraphContext().commit();
            }
        }
    }
}

