/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Extendable;
import org.jboss.forge.roaster.model.InterfaceCapable;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.Commit;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ClassifyFileTypesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.WindupWildcardImportResolver;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ClassifyFileTypesPhase.class)
public class IndexJavaSourceFilesRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(IndexJavaSourceFilesRuleProvider.class);
    public static final String TECH_TAG = "Java Source";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(JavaSourceFileModel.class)).perform((Operation)new IndexJavaFileIterationOperator().and((Operation)Commit.every((int)100)).and((Operation)IterationProgress.monitoring((String)"Index Java Source Files", (int)250)));
    }

    private final class IndexJavaFileIterationOperator
    extends AbstractIterationOperation<JavaSourceFileModel> {
        private static final int JAVA_SUFFIX_LEN = 5;

        private IndexJavaFileIterationOperator() {
        }

        private String getInputPathForSource(WindupConfigurationModel configuration, String javaPath) {
            for (FileModel input : configuration.getInputPaths()) {
                if (!javaPath.startsWith(input.getFilePath())) continue;
                return input.getFilePath();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(GraphRewrite event, EvaluationContext context, JavaSourceFileModel payload) {
            WindupWildcardImportResolver.setContext(event.getGraphContext());
            try {
                TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
                GraphContext graphContext = event.getGraphContext();
                WindupConfigurationModel configuration = (WindupConfigurationModel)new GraphService(graphContext, WindupConfigurationModel.class).getUnique();
                String filepath = payload.getFilePath();
                filepath = Paths.get(filepath, new String[0]).toAbsolutePath().toString();
                String inputDir = this.getInputPathForSource(configuration, filepath);
                String classFilePath = inputDir != null ? filepath.substring(inputDir.length() + 1) : payload.getPrettyPathWithinProject();
                String qualifiedName = classFilePath.replace(File.separatorChar, '.').substring(0, classFilePath.length() - 5);
                String packageName = "";
                if (qualifiedName.contains(".")) {
                    packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
                }
                if (packageName.startsWith("src.main.java.")) {
                    packageName = packageName.substring("src.main.java.".length());
                }
                technologyTagService.addTagToFileModel((FileModel)payload, IndexJavaSourceFilesRuleProvider.TECH_TAG, TECH_TAG_LEVEL);
                payload.setPackageName(packageName);
                try (FileInputStream fis = new FileInputStream(payload.getFilePath());){
                    this.addParsedClassToFile(event, context, payload, fis);
                }
                catch (FileNotFoundException e) {
                    throw new WindupException("File in " + payload.getFilePath() + " was not found.", (Throwable)e);
                }
                catch (IOException e) {
                    throw new WindupException("IOException thrown when parsing file located in " + payload.getFilePath(), (Throwable)e);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not parse java file: " + payload.getFilePath() + " due to: " + e.getMessage(), e);
                    ClassificationService classificationService = new ClassificationService(graphContext);
                    classificationService.attachClassification(event, context, (FileModel)payload, "Unparseable Java File", "This Java file could not be parsed");
                    payload.setParseError("Unparseable Java File: " + e.getMessage());
                    WindupWildcardImportResolver.setContext(null);
                    return;
                }
            }
            finally {
                WindupWildcardImportResolver.setContext(null);
            }
        }

        private void addParsedClassToFile(GraphRewrite event, EvaluationContext context, JavaSourceFileModel sourceFileModel, FileInputStream fis) {
            Extendable extendable;
            String superclassName;
            InterfaceCapable interfaceCapable;
            List interfaceNames;
            String qualifiedName;
            JavaSource javaSource;
            try {
                javaSource = (JavaSource)Roaster.parse(JavaSource.class, (InputStream)fis);
            }
            catch (ParserException e) {
                ClassificationService classificationService = new ClassificationService(event.getGraphContext());
                classificationService.attachClassification(event, context, (FileModel)sourceFileModel, "Unparseable Java File", "This Java file could not be parsed");
                sourceFileModel.setParseError("Unparseable Java File: " + e.getMessage());
                return;
            }
            String packageName = javaSource.getPackage();
            sourceFileModel.setPackageName(packageName);
            Path rootSourcePath = PathUtil.getRootFolderForSource((Path)sourceFileModel.asFile().toPath(), (String)packageName);
            if (rootSourcePath != null) {
                FileModel rootSourceFileModel = new FileService(event.getGraphContext()).createByFilePath(rootSourcePath.toString());
                sourceFileModel.setRootSourceFolder(rootSourceFileModel);
            }
            String simpleName = qualifiedName = javaSource.getQualifiedName();
            if (packageName != null && !packageName.isEmpty() && simpleName != null) {
                simpleName = simpleName.substring(packageName.length() + 1);
            }
            JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
            JavaClassModel javaClassModel = javaClassService.create(qualifiedName);
            javaClassModel.setOriginalSource(sourceFileModel);
            javaClassModel.setSimpleName(simpleName);
            javaClassModel.setPackageName(packageName);
            javaClassModel.setQualifiedName(qualifiedName);
            javaClassModel.setClassFile(sourceFileModel);
            javaClassModel.setPublic(javaSource.isPublic());
            javaClassModel.setInterface(javaSource.isInterface());
            if (javaSource instanceof InterfaceCapable && (interfaceNames = (interfaceCapable = (InterfaceCapable)javaSource).getInterfaces()) != null) {
                for (String iface : interfaceNames) {
                    JavaClassModel interfaceModel = javaClassService.getOrCreatePhantom(iface);
                    javaClassService.addInterface(javaClassModel, interfaceModel);
                }
            }
            if (!javaSource.isInterface() && javaSource instanceof Extendable && !Strings.isNullOrEmpty((String)(superclassName = (extendable = (Extendable)javaSource).getSuperType()))) {
                javaClassModel.setExtends(javaClassService.getOrCreatePhantom(superclassName));
            }
            sourceFileModel.addJavaClass(javaClassModel);
        }

        public String toString() {
            return "AttachJavaSourceInformationToGraph";
        }
    }
}

