/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import javax.inject.Inject;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.Commit;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ArchiveExtractionPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.IgnoredArchiveModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.Service;
import org.jboss.windup.rules.apps.java.archives.identify.ArchiveIdentificationService;
import org.jboss.windup.rules.apps.java.archives.identify.CompositeArchiveIdentificationService;
import org.jboss.windup.rules.apps.java.condition.SourceMode;
import org.jboss.windup.rules.apps.java.scan.operation.UnzipArchiveToOutputFolder;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ArchiveExtractionPhase.class)
public class UnzipArchivesToOutputRuleProvider
extends AbstractRuleProvider {
    @Inject
    private CompositeArchiveIdentificationService identificationService;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        UnzipArchiveToOutputFolder unzipArchives = new UnzipArchiveToOutputFolder((ArchiveIdentificationService)this.identificationService);
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(ArchiveModel.class), new Condition[]{SourceMode.isEnabled()}).perform((Operation)new IgnoreArchivesInSourceModeOperation()).addRule().when((Condition)Query.fromType(ArchiveModel.class).excludingType(IgnoredArchiveModel.class), new Condition[]{SourceMode.isDisabled()}).perform((Operation)unzipArchives, new Operation[]{IterationProgress.monitoring((String)"Unzipped archive", (int)1), Commit.every((int)1)}).addRule().when((Condition)Query.fromType(ArchiveModel.class).excludingType(DuplicateArchiveModel.class)).perform((Operation)new DuplicateArchiveOperation());
    }

    private class DuplicateArchiveOperation
    extends AbstractIterationOperation<ArchiveModel> {
        private DuplicateArchiveOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel canonicalArchive) {
            if (!canonicalArchive.getDuplicateArchives().iterator().hasNext()) {
                return;
            }
            boolean exclusiveToApplication = true;
            ArchiveModel rootArchive = canonicalArchive.getRootArchiveModel();
            for (DuplicateArchiveModel duplicateArchiveModel : canonicalArchive.getDuplicateArchives()) {
                if (rootArchive.containsArchive((ArchiveModel)duplicateArchiveModel)) continue;
                exclusiveToApplication = false;
                break;
            }
            if (exclusiveToApplication) {
                return;
            }
            ArchiveModel canonicalParentArchive = canonicalArchive.getParentArchive();
            FileModel canonicalArchiveParentFile = canonicalArchive.getParentFile();
            canonicalArchive.setParentFile(null);
            canonicalArchive.setParentArchive(null);
            Service duplicateArchiveService = event.getGraphContext().service(DuplicateArchiveModel.class);
            DuplicateArchiveModel duplicateArchive = (DuplicateArchiveModel)duplicateArchiveService.create();
            duplicateArchive.setCanonicalArchive(canonicalArchive);
            duplicateArchive.setSHA1Hash(canonicalArchive.getSHA1Hash());
            duplicateArchive.setFilePath(canonicalArchive.getFilePath());
            duplicateArchive.setArchiveName(canonicalArchive.getArchiveName());
            duplicateArchive.setFileName(canonicalArchive.getFileName());
            duplicateArchive.setParentArchive(canonicalParentArchive);
            duplicateArchive.setParentFile(canonicalArchiveParentFile);
        }
    }

    private class IgnoreArchivesInSourceModeOperation
    extends AbstractIterationOperation<ArchiveModel> {
        private IgnoreArchivesInSourceModeOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
            IgnoredArchiveModel ignoredArchive = (IgnoredArchiveModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, IgnoredArchiveModel.class);
            ignoredArchive.setIgnoredRegex("Archives ignored in source mode");
        }
    }
}

