/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.maven.dao;

import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;

public class MavenProjectService
extends GraphService<MavenProjectModel> {
    public MavenProjectService(GraphContext context) {
        super(context, MavenProjectModel.class);
    }

    public MavenProjectModel createMavenStub(String groupId, String artifactId, String version) {
        MavenProjectModel facet = (MavenProjectModel)this.create();
        facet.setMavenIdentifier(this.generateMavenKey(groupId, artifactId, version));
        facet.setGroupId(groupId);
        facet.setArtifactId(artifactId);
        facet.setVersion(version);
        return facet;
    }

    public Iterable<MavenProjectModel> findByGroupArtifactVersion(String groupId, String artifactId, String version) {
        String key = this.generateMavenKey(groupId, artifactId, version);
        Iterable facet = this.findAllByProperty("mavenIdentifier", key);
        return facet;
    }

    protected String generateMavenKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public boolean isMavenConfiguration(XmlFileModel resource) {
        return new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{resource}).in(new String[]{"xmlFacet"}).as("facet", new String[0]).has("w:winduptype", (Object)GraphTypeManager.getTypeValue((Class)this.getType())).select("facet").hasNext();
    }

    public MavenProjectModel getMavenConfigurationFromResource(XmlFileModel resource) {
        GraphTraversal v = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{resource}).in(new String[]{"xmlFacet"}).as("facet", new String[0]).has("w:winduptype", (Object)GraphTypeManager.getTypeValue((Class)this.getType())).select("facet");
        if (v.hasNext()) {
            return (MavenProjectModel)this.getGraphContext().getFramed().frameElement((Element)v.next(), this.getType());
        }
        return null;
    }
}

