/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import java.util.Iterator;
import java.util.logging.Logger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.util.Logging;

public class ArchiveCoordinateService
extends GraphService<ArchiveCoordinateModel> {
    private static final Logger LOG = Logging.get(ArchiveCoordinateService.class);

    public ArchiveCoordinateService(GraphContext context, Class<ArchiveCoordinateModel> type) {
        super(context, type);
    }

    public ArchiveCoordinateModel getSingleOrCreate(String groupId, String artifactId, String version) {
        ArchiveCoordinateModel archive = this.findSingle(groupId, artifactId, version);
        if (archive != null) {
            return archive;
        }
        return ((ArchiveCoordinateModel)this.create()).setGroupId(groupId).setArtifactId(artifactId).setVersion(version);
    }

    public ArchiveCoordinateModel findSingle(String groupId, String artifactId, String version) {
        Iterable<ArchiveCoordinateModel> archives = this.findByGAV(groupId, artifactId, version);
        Iterator<ArchiveCoordinateModel> it = archives.iterator();
        if (!it.hasNext()) {
            return null;
        }
        ArchiveCoordinateModel archive = it.next();
        if (it.hasNext()) {
            LOG.warning(String.format("There are multiple %s's like this: %s:%s:%s", ArchiveCoordinateModel.class.getSimpleName(), groupId, artifactId, version));
        }
        return archive;
    }

    public Iterable<ArchiveCoordinateModel> findByGAV(String groupId, String artifactId, String version) {
        Iterable archives = this.findAllByProperties(new String[]{"ArchiveCoordinateModel-groupId", "ArchiveCoordinateModel-artifactId", "ArchiveCoordinateModel-version"}, new String[]{groupId, artifactId, version});
        return archives;
    }
}

