/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.middleware.tattletale.reports;

import com.redhat.gss.middleware.tattletale.reports.AbstractExtendedProfile;
import com.redhat.gss.middleware.tattletale.reports.EAP429;
import com.redhat.gss.middleware.tattletale.reports.EAP4310;
import com.redhat.gss.middleware.tattletale.reports.EAP512;
import com.redhat.gss.middleware.tattletale.reports.EAP600;
import com.redhat.gss.middleware.tattletale.reports.EAP700;
import com.redhat.gss.middleware.tattletale.reports.Main;
import com.redhat.gss.middleware.tattletale.reports.ProblematicArchive;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.profiles.AbstractProfile;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;
import org.jboss.tattletale.reporting.SummaryDetailReport;

public class PackagedJBossClasses
extends SummaryDetailReport {
    private static final String NAME = "Packaged JBoss Classes";
    private static final String DIRECTORY = "packaged-jboss-classes";
    private Set<ProblematicArchive> problemSet = new TreeSet<ProblematicArchive>();
    private AbstractExtendedProfile[] profiles = new AbstractExtendedProfile[]{this.getEAPProfile()};
    private Properties config = null;
    private int classListId = 1;

    public PackagedJBossClasses() {
        super(DIRECTORY, 1, NAME, DIRECTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDefaultConfiguration() {
        FileInputStream fis;
        Properties properties = new Properties();
        String propertiesFile = System.getProperty("jboss-tattletale.properties");
        boolean loaded = false;
        if (propertiesFile != null) {
            fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                loaded = true;
            }
            catch (IOException ioe) {
                System.err.println("Unable to open " + propertiesFile);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            fis = null;
            try {
                fis = new FileInputStream("jboss-tattletale.properties");
                properties.load(fis);
                loaded = true;
            }
            catch (IOException ioe) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            InputStream is = null;
            try {
                ClassLoader cl = Main.class.getClassLoader();
                is = cl.getResourceAsStream("jboss-tattletale.properties");
                properties.load(is);
                loaded = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    public void setConfig(Properties config) {
        this.config = config;
    }

    private AbstractExtendedProfile getEAPProfile() {
        String eapVersion;
        if (this.config == null) {
            this.config = this.loadDefaultConfiguration();
        }
        if ((eapVersion = System.getProperty("EAP")) == null) {
            eapVersion = (String)this.config.get("EAP");
        }
        return this.getEAPProfile(eapVersion);
    }

    private AbstractExtendedProfile getEAPProfile(String eapVersion) {
        if (eapVersion != null) {
            if (eapVersion.contains("4.2")) {
                System.out.println("Using EAP 4.2 Profile");
                return new EAP429();
            }
            if (eapVersion.contains("4.3")) {
                System.out.println("Using EAP 4.3 Profile");
                return new EAP4310();
            }
            if (eapVersion.contains("5")) {
                System.out.println("Using EAP 5.1.x Profile");
                return new EAP512();
            }
            if (eapVersion.contains("6")) {
                System.out.println("Using EAP 6.0.0 Profile");
                return new EAP600();
            }
            if (eapVersion.contains("7")) {
                System.out.println("Using EAP 7.0.0 Profile");
                return new EAP700();
            }
        }
        System.out.println("Using EAP 5.1.x Profile");
        return new EAP512();
    }

    private void writeLocations(BufferedWriter bw, SortedSet<Location> locations) throws IOException {
        bw.write("<h5>Location: ");
        for (Location l : locations) {
            bw.write(l.getFilename() + " ");
        }
        bw.write("</h5>" + Dump.newLine());
    }

    private void writeArchiveName(BufferedWriter bw, Archive archive) throws IOException {
        bw.write("<h2>Archive: " + archive.getName() + " contains these classes which should not be packaged:</h2>" + Dump.newLine());
        this.writeLocations(bw, archive.getLocations());
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        this.analyze();
        this.writeSummary(bw);
        bw.write("<div id='left-right-parent'>" + Dump.newLine());
        this.writeHtmlBodyLeft(bw);
        this.writeHtmlBodyRight(bw);
        bw.write("</div'>" + Dump.newLine());
    }

    private void writeDetailToFile(BufferedWriter bw) throws IOException {
        String[] profileProblemLevel = new String[]{"PROBLEM", "PROBLEM"};
        boolean groupOutputByJBossJar = true;
        HashMap<String, ArrayList<String>> jbossClassLocationsMap = new HashMap<String, ArrayList<String>>();
        bw.write("<div id=\"dialog\" style='display:none'><iframe id=\"iframe\" width='800' height='400'></iframe></div>");
        bw.write("<script> $(document).ready(function() { $('#dialog').dialog({position:['right','top'], minWidth:850, minHeight:450, autoOpen:true}); });");
        bw.write("function switchDialog(el, newSrc, title) { $('#'+el.id).toggleClass('green-selected'); $('#iframe').attr('src',newSrc); if(! $('#dialog').dialog('isOpen') != true) { $('#dialog').dialog('open');} }");
        bw.write("</script>");
        for (ProblematicArchive problemmaticArchive : this.problemSet) {
            boolean archiveNameWritten = false;
            Archive archive = problemmaticArchive.archive;
            Set<String> classes = archive.getProvides().keySet();
            int i = -1;
            for (AbstractExtendedProfile profile : this.profiles) {
                ++i;
                boolean profileNameWritten = false;
                for (String clz : classes) {
                    if (!profile.doesProvide(clz)) continue;
                    if (!groupOutputByJBossJar && !archiveNameWritten) {
                        this.writeArchiveName(bw, archive);
                        archiveNameWritten = true;
                    }
                    if (!profileNameWritten) {
                        bw.write("<h3>" + profileProblemLevel[i] + " - '" + profile.getName() + "' already contains these classes:</h3>" + Dump.newLine());
                        bw.write("<ul>" + Dump.newLine());
                        profileNameWritten = true;
                    }
                    List<String> locationsInJBoss = profile.getLocationProvided(clz);
                    String locationInJBoss = "";
                    if (locationsInJBoss != null) {
                        locationInJBoss = locationsInJBoss.toString();
                    }
                    if (!groupOutputByJBossJar) {
                        bw.write("<li>" + clz + " " + locationInJBoss + "</li>" + Dump.newLine());
                        continue;
                    }
                    for (String loc : locationsInJBoss) {
                        ArrayList<String> list = (ArrayList<String>)jbossClassLocationsMap.get(loc);
                        if (list == null) {
                            list = new ArrayList<String>();
                        }
                        list.add(clz);
                        jbossClassLocationsMap.put(loc, list);
                    }
                }
                if (profileNameWritten) {
                    bw.write("</ul>" + Dump.newLine());
                }
                if (!groupOutputByJBossJar) continue;
                bw.write("<h4>" + this.addColor(this.asString(archive.getLocations()), "red") + " duplicates classes in :</h4>");
                bw.write("<ul>" + Dump.newLine());
                for (String jbossJar : jbossClassLocationsMap.keySet()) {
                    ++this.classListId;
                    ArrayList classList = (ArrayList)jbossClassLocationsMap.get(jbossJar);
                    String jbossJarFileName = jbossJar.replace("/", "-") + ".html";
                    String displayClassesJavaScript = "\"switchDialog(this,'" + jbossJarFileName + "', '" + jbossJar + "')\"";
                    String unHighlight = "\"$(this).toggleClass('green-selected');\"";
                    bw.write("<li id=\"cl" + this.classListId + "\" onmouseover=" + displayClassesJavaScript + " onmouseout=" + unHighlight + ">" + this.addColor(jbossJar, "green"));
                    bw.write(Dump.newLine());
                    bw.write("</li>" + Dump.newLine());
                    BufferedWriter out = new BufferedWriter(new FileWriter(new File(this.getOutputDirectory(), jbossJarFileName)));
                    out.write(jbossJar + "already contains these classes:<br/>" + Dump.newLine());
                    out.write("<ul class=\"toggleOff>\"" + Dump.newLine());
                    for (String clz : classList) {
                        out.write("<li>" + clz + "</li>" + Dump.newLine());
                    }
                    out.write("</ul>" + Dump.newLine());
                    out.close();
                }
                bw.write("</ul>" + Dump.newLine());
                jbossClassLocationsMap.clear();
            }
        }
    }

    private void writeDetailed(BufferedWriter bw) throws IOException {
        bw.write("<h1>Detailed analysis of problematic archives:</h1>");
        String[] profileProblemLevel = new String[]{"PROBLEM", "PROBLEM"};
        boolean groupOutputByJBossJar = true;
        HashMap<String, ArrayList<String>> jbossClassLocationsMap = new HashMap<String, ArrayList<String>>();
        for (ProblematicArchive problemmaticArchive : this.problemSet) {
            boolean archiveNameWritten = false;
            Archive archive = problemmaticArchive.archive;
            Set<String> classes = archive.getProvides().keySet();
            int i = -1;
            for (AbstractExtendedProfile profile : this.profiles) {
                ++i;
                boolean profileNameWritten = false;
                for (String clz : classes) {
                    if (!profile.doesProvide(clz)) continue;
                    if (!groupOutputByJBossJar && !archiveNameWritten) {
                        this.writeArchiveName(bw, archive);
                        archiveNameWritten = true;
                    }
                    if (!profileNameWritten) {
                        bw.write("<h3>" + profileProblemLevel[i] + " - '" + profile.getName() + "' already contains these classes:</h3>" + Dump.newLine());
                        bw.write("<ul>" + Dump.newLine());
                        profileNameWritten = true;
                    }
                    List<String> locationsInJBoss = profile.getLocationProvided(clz);
                    String locationInJBoss = "";
                    if (locationsInJBoss != null) {
                        locationInJBoss = locationsInJBoss.toString();
                    }
                    if (!groupOutputByJBossJar) {
                        bw.write("<li>" + clz + " " + locationInJBoss + "</li>" + Dump.newLine());
                        continue;
                    }
                    for (String loc : locationsInJBoss) {
                        ArrayList<String> list = (ArrayList<String>)jbossClassLocationsMap.get(loc);
                        if (list == null) {
                            list = new ArrayList<String>();
                        }
                        list.add(clz);
                        jbossClassLocationsMap.put(loc, list);
                    }
                }
                if (profileNameWritten) {
                    bw.write("</ul>" + Dump.newLine());
                }
                if (!groupOutputByJBossJar) continue;
                for (String jbossJar : jbossClassLocationsMap.keySet()) {
                    ++this.classListId;
                    ArrayList classList = (ArrayList)jbossClassLocationsMap.get(jbossJar);
                    bw.write("<h4> The class below from " + this.addColor(this.asString(archive.getLocations()), "red") + " are already contained in " + profile.getName() + " jar " + this.addColor(jbossJar, "green") + "</h4>" + Dump.newLine());
                    bw.write("<span onclick=\"$('#cl" + this.classListId + "').toggle( 'blind', {}, 500, null);\">Show/Hide Details</span>");
                    bw.write("<ul class=\"toggleOff\" id=\"cl" + this.classListId + "\">" + Dump.newLine());
                    for (String clz : classList) {
                        bw.write("<li>" + clz + "</li>" + Dump.newLine());
                    }
                    bw.write("</ul>" + Dump.newLine());
                }
                jbossClassLocationsMap.clear();
            }
        }
    }

    private void analyze() {
        for (Archive archive : this.archives) {
            ArrayList<Archive> archiveQueue = new ArrayList<Archive>();
            ArrayList<Archive> newItems = new ArrayList<Archive>();
            archiveQueue.add(archive);
            ListIterator it = archiveQueue.listIterator();
            while (it.hasNext()) {
                Archive a = (Archive)it.next();
                it.remove();
                if (a instanceof NestableArchive) {
                    newItems.addAll(((NestableArchive)a).getSubArchives());
                }
                if (a.getType() == 1) {
                    Set<String> classes = a.getProvides().keySet();
                    ArrayList<AbstractProfile> profilesMatched = new ArrayList<AbstractProfile>();
                    block2: for (AbstractExtendedProfile profile : this.profiles) {
                        for (String clz : classes) {
                            List<String> locations = profile.getLocationProvided(clz);
                            if (locations == null) continue;
                            profilesMatched.add(profile);
                            continue block2;
                        }
                    }
                    if (profilesMatched.size() > 0) {
                        this.problemSet.add(new ProblematicArchive(a, profilesMatched));
                    }
                }
                if (it.hasNext() || newItems.size() <= 0) continue;
                archiveQueue.addAll(newItems);
                newItems.clear();
                it = archiveQueue.listIterator();
            }
        }
    }

    private void writeSummary(BufferedWriter bw) throws IOException {
        bw.write("<h1>Summary of problematic archives:</h1>");
        bw.write("<ul>");
        for (ProblematicArchive a : this.problemSet) {
            for (Location l : a.archive.getLocations()) {
                bw.write("<li>" + l.getFilename() + " [ " + this.profilesListToString(a.profiles) + "]</li>");
            }
        }
        bw.write("</ul>");
    }

    private String profilesListToString(List<AbstractProfile> list) {
        StringBuilder sb = new StringBuilder();
        for (AbstractProfile profile : list) {
            sb.append(profile.getName() + ", ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private void writeJQueryHeader(BufferedWriter bw) throws IOException {
        bw.write("<style>" + Dump.newLine());
        bw.write(".green { color: green; background-color:transparent; }" + Dump.newLine());
        bw.write(".red { color: red; background-color:transparent; }" + Dump.newLine());
        bw.write(".green-selected { color: white; background-color:black; }" + Dump.newLine());
        bw.write(".jbossJar { color: green; background-color:transparent; }" + Dump.newLine());
        bw.write("#left {  left:0px; width:49%;height:100%;float:left; border:1px solid black; overflow: scroll }" + Dump.newLine());
        bw.write("#right { left:51%;width:49%;height:100%;float:right; border:1px solid black; }" + Dump.newLine());
        bw.write("#left-right-parent { width:98%;height:100%; }" + Dump.newLine());
        bw.write(".toggleOff{ }" + Dump.newLine());
        bw.write("</style>" + Dump.newLine());
        bw.write("<link type=\"text/css\" href=\"jquery/css/ui-lightness/jquery-ui-1.8.18.custom.css\" rel=\"stylesheet\"/>");
        bw.write("<script type=\"text/javascript\" src=\"jquery/js/jquery-1.7.1.min.js\"></script>");
        bw.write("<script type=\"text/javascript\" src=\"jquery/js/jquery-ui-1.8.18.custom.min.js\"></script>");
        bw.write("<script>$(document).ready(function() { $('.toggleOff').toggle(false); });</script>");
        File outputDir = this.getOutputDirectory();
        for (String filePath : new String[]{"jquery/css/ui-lightness/jquery-ui-1.8.18.custom.css", "jquery/js/jquery-1.7.1.min.js", "jquery/js/jquery-ui-1.8.18.custom.min.js"}) {
            int oneChar;
            URL url = PackagedJBossClasses.class.getClassLoader().getResource(filePath);
            File dir = new File(outputDir, filePath.substring(0, filePath.lastIndexOf("/") + 1));
            dir.mkdirs();
            InputStream is = url.openStream();
            FileOutputStream fos = new FileOutputStream(new File(outputDir, filePath));
            int count = 0;
            while ((oneChar = is.read()) != -1) {
                fos.write(oneChar);
                ++count;
            }
            is.close();
            fos.close();
        }
    }

    private void writeHtmlBodyLeft(BufferedWriter bw) throws IOException {
        bw.write("<span id='left'>" + Dump.newLine());
        String[] profileProblemLevel = new String[]{"PROBLEM", "PROBLEM"};
        boolean groupOutputByJBossJar = true;
        bw.write("<script> " + Dump.newLine());
        bw.write("var previousSelected = null; function switchDialog(el, newSrc, title) { if(previousSelected) $('#'+previousSelected.id).toggleClass('green-selected'); $('#'+el.id).toggleClass('green-selected'); $('#iframe').attr('src',newSrc); previousSelected=el; }");
        bw.write("</script>");
        HashMap<String, ArrayList<String>> jbossClassLocationsMap = new HashMap<String, ArrayList<String>>();
        for (ProblematicArchive problemmaticArchive : this.problemSet) {
            boolean archiveNameWritten = false;
            Archive archive = problemmaticArchive.archive;
            Set<String> classes = archive.getProvides().keySet();
            int i = -1;
            for (AbstractExtendedProfile profile : this.profiles) {
                ++i;
                boolean profileNameWritten = false;
                for (String clz : classes) {
                    if (!profile.doesProvide(clz)) continue;
                    if (!groupOutputByJBossJar && !archiveNameWritten) {
                        this.writeArchiveName(bw, archive);
                        archiveNameWritten = true;
                    }
                    if (!profileNameWritten) {
                        bw.write("<h3>" + profileProblemLevel[i] + " - '" + profile.getName() + "' already contains these classes:</h3>" + Dump.newLine());
                        bw.write("<ul>" + Dump.newLine());
                        profileNameWritten = true;
                    }
                    List<String> locationsInJBoss = profile.getLocationProvided(clz);
                    String locationInJBoss = "";
                    if (locationsInJBoss != null) {
                        locationInJBoss = locationsInJBoss.toString();
                    }
                    if (!groupOutputByJBossJar) {
                        bw.write("<li>" + clz + " " + locationInJBoss + "</li>" + Dump.newLine());
                        continue;
                    }
                    for (String loc : locationsInJBoss) {
                        ArrayList<String> list = (ArrayList<String>)jbossClassLocationsMap.get(loc);
                        if (list == null) {
                            list = new ArrayList<String>();
                        }
                        list.add(clz);
                        jbossClassLocationsMap.put(loc, list);
                    }
                }
                if (profileNameWritten) {
                    bw.write("</ul>" + Dump.newLine());
                }
                if (!groupOutputByJBossJar) continue;
                bw.write("<h4>" + this.addColor(this.asString(archive.getLocations()), "red") + " duplicates classes in :</h4>");
                bw.write("<ul>" + Dump.newLine());
                for (String jbossJar : jbossClassLocationsMap.keySet()) {
                    ++this.classListId;
                    ArrayList classList = (ArrayList)jbossClassLocationsMap.get(jbossJar);
                    String jbossJarFileName = jbossJar.replace("/", "-") + ".html";
                    String displayClassesJavaScript = "\"switchDialog(this,'" + jbossJarFileName + "', '" + jbossJar + "')\"";
                    String unHighlight = "\"$(this).toggleClass('green-selected');\"";
                    bw.write("<li id=\"cl" + this.classListId + "\" onclick=" + displayClassesJavaScript + ">" + this.addClass(jbossJar, "jbossJar"));
                    bw.write(Dump.newLine());
                    bw.write("</li>" + Dump.newLine());
                    BufferedWriter out = new BufferedWriter(new FileWriter(new File(this.getOutputDirectory(), jbossJarFileName)));
                    out.write(jbossJar + "already contains these classes:<br/>" + Dump.newLine());
                    out.write("<ul class=\"toggleOff>\"" + Dump.newLine());
                    for (String clz : classList) {
                        out.write("<li>" + clz + "</li>" + Dump.newLine());
                    }
                    out.write("</ul>" + Dump.newLine());
                    out.close();
                }
                bw.write("</ul>" + Dump.newLine());
                jbossClassLocationsMap.clear();
            }
        }
        bw.write("</span>" + Dump.newLine());
    }

    private void writeHtmlBodyRight(BufferedWriter bw) throws IOException {
        bw.write("<span id='right'>" + Dump.newLine());
        bw.write("<iframe id='iframe' style='width:100%;height:100%;'></iframe>" + Dump.newLine());
        bw.write("</span>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        this.writeJQueryHeader(bw);
        bw.write("<body style='width:100%;height:100%;'>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Packaged JBoss Classes</h1>" + Dump.newLine());
        bw.write("<h3>" + this.addColor("POSSIBLE PROBLEM", "orange") + " - indicates these classes will most likely cause ClassCastExceptions and should be removed</h3>" + Dump.newLine());
        bw.write("<p>");
        bw.write("JBoss Enterprise Application Platform is a Java Enterprise Edition (J2EE) certified implementation application container.");
        bw.write("J2EE containers are required to implement various specifications versions, such as Java Persistence API (JPA), Java Server Faces (JSF), etc.");
        bw.write("Other issues occur when an application packages a JDK API which conflicts with the JDK, some other servlet containers such as Apache Tomcat ignore these classes, so they were never actually used, however JBoss will try to use them and thus they should be removed or JBoss configured to ignore them");
        bw.write("In contrast with Servlet containers such as Apache Tomcat, which do not include all of the specifications that a J2EE container does, this is why web applications (wars) being migrated to a J2EE application containers often encounter classloading issues.");
        bw.write("The issues are a result of the application server's implementation of a particular specification trying to do its job and finding a diffferent version of the APIs or implementation classes in the application being migrated.");
        bw.write("</p>");
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine() + "<br/>");
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }

    @Override
    public void writeHtmlSummary(BufferedWriter bw) throws IOException {
        this.writeSummary(bw);
    }

    @Override
    public void writeHtmlDetailed(BufferedWriter bw) throws IOException {
    }

    private String asString(SortedSet<Location> locations) {
        String st = "[";
        for (Location l : locations) {
            st = st + l.getFilename() + ", ";
        }
        return st + "]";
    }

    private String addColor(String st, String color) {
        return "<span style='color:" + color + "'>" + st + "</span>";
    }

    private String addClass(String st, String clazz) {
        return "<span class='" + clazz + "'>" + st + "</span>";
    }
}

