/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.middleware.tattletale.reports;

import com.redhat.gss.middleware.tattletale.reports.ProblematicArchive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.profiles.AbstractProfile;
import org.jboss.tattletale.profiles.JavaEE5;
import org.jboss.tattletale.profiles.SunJava6;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;
import org.jboss.tattletale.reporting.SummaryDetailReport;

public class PackagedJDKJ2EEFrameworksReport
extends SummaryDetailReport {
    private static final String NAME = "Packaged JDK / J2EE Framework Classes";
    private static final String DIRECTORY = "packaged-jdk-j2ee-framework-classes";
    private Set<ProblematicArchive> problemSet = new TreeSet<ProblematicArchive>();

    public PackagedJDKJ2EEFrameworksReport() {
        super(DIRECTORY, 1, NAME, DIRECTORY);
    }

    private void writeLocations(BufferedWriter bw, SortedSet<Location> locations) throws IOException {
        bw.write("<h5>Location: ");
        for (Location l : locations) {
            bw.write(l.getFilename() + " ");
        }
        bw.write("</h5>" + Dump.newLine());
    }

    private void writeArchiveName(BufferedWriter bw, Archive archive) throws IOException {
        bw.write("<h2>Archive: " + archive.getName() + " contains these classes which should not be packaged:</h2>" + Dump.newLine());
        this.writeLocations(bw, archive.getLocations());
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        this.analyze();
        this.writeSummary(bw);
        this.writeDetailed(bw);
    }

    private void writeDetailed(BufferedWriter bw) throws IOException {
        bw.write("<h1>Detailed analysis of problematic archives:</h1>");
        String[] profileProblemLevel = new String[]{"PROBLEM", "PROBLEM"};
        AbstractProfile[] profiles = new AbstractProfile[]{new SunJava6(), new JavaEE5()};
        for (ProblematicArchive problemmaticArchive : this.problemSet) {
            boolean archiveNameWritten = false;
            Archive archive = problemmaticArchive.archive;
            Set<String> classes = archive.getProvides().keySet();
            int i = -1;
            for (AbstractProfile profile : profiles) {
                ++i;
                boolean profileNameWritten = false;
                for (String clz : classes) {
                    if (!profile.doesProvide(clz)) continue;
                    if (!archiveNameWritten) {
                        this.writeArchiveName(bw, archive);
                        archiveNameWritten = true;
                    }
                    if (!profileNameWritten) {
                        bw.write("<h3>" + profileProblemLevel[i] + " - '" + profile.getName() + "' already contains these classes:</h3>" + Dump.newLine());
                        bw.write("<ul>" + Dump.newLine());
                        profileNameWritten = true;
                    }
                    bw.write("<li>" + clz + "</li>" + Dump.newLine());
                }
                if (!profileNameWritten) continue;
                bw.write("</ul>" + Dump.newLine());
            }
        }
    }

    private void analyze() {
        AbstractProfile[] profiles = new AbstractProfile[]{new SunJava6(), new JavaEE5()};
        for (Archive archive : this.archives) {
            ArrayList<Archive> archiveQueue = new ArrayList<Archive>();
            ArrayList<Archive> newItems = new ArrayList<Archive>();
            archiveQueue.add(archive);
            ListIterator it = archiveQueue.listIterator();
            while (it.hasNext()) {
                Archive a = (Archive)it.next();
                it.remove();
                if (a instanceof NestableArchive) {
                    newItems.addAll(((NestableArchive)a).getSubArchives());
                }
                if (a.getType() == 1) {
                    Set<String> classes = a.getProvides().keySet();
                    ArrayList<AbstractProfile> profilesMatched = new ArrayList<AbstractProfile>();
                    block2: for (AbstractProfile profile : profiles) {
                        for (String clz : classes) {
                            if (!profile.doesProvide(clz)) continue;
                            profilesMatched.add(profile);
                            continue block2;
                        }
                    }
                    if (profilesMatched.size() > 0) {
                        this.problemSet.add(new ProblematicArchive(a, profilesMatched));
                    }
                }
                if (it.hasNext() || newItems.size() <= 0) continue;
                archiveQueue.addAll(newItems);
                newItems.clear();
                it = archiveQueue.listIterator();
            }
        }
    }

    private void writeSummary(BufferedWriter bw) throws IOException {
        bw.write("<h1>Summary of problematic archives:</h1>");
        bw.write("<ul>");
        for (ProblematicArchive a : this.problemSet) {
            for (Location l : a.archive.getLocations()) {
                bw.write("<li>" + l.getFilename() + " [" + this.profilesListToString(a.profiles) + "]</li>");
            }
        }
        bw.write("</ul>");
    }

    private String profilesListToString(List<AbstractProfile> list) {
        StringBuilder sb = new StringBuilder();
        for (AbstractProfile profile : list) {
            sb.append(profile.getName() + ", ");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Packaged JDK / J2EE Framework Classes</h1>" + Dump.newLine());
        bw.write("<h3>PROBLEM - indicates these classes will most likely cause ClassCastExceptions and should be removed</h3>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine() + "<br/>");
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }

    @Override
    public void writeHtmlSummary(BufferedWriter bw) throws IOException {
        this.writeSummary(bw);
    }

    @Override
    public void writeHtmlDetailed(BufferedWriter bw) throws IOException {
        this.writeDetailed(bw);
    }
}

