/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public class DirectoryScanner {
    private static Set<String> archives = new HashSet<String>();

    private DirectoryScanner() {
    }

    public static void setArchives(String scan) {
        archives.clear();
        if (scan != null) {
            StringTokenizer st = new StringTokenizer(scan, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("*")) {
                    token = token.substring(1);
                }
                archives.add(token.toLowerCase(Locale.US));
            }
        }
        if (archives.isEmpty()) {
            archives.add(".jar");
            archives.add(".war");
        }
    }

    public static List<File> scan(File file) {
        return DirectoryScanner.scan(file, null);
    }

    public static List<File> scan(File file, Set<String> excludes) {
        try {
            return DirectoryScanner.getFileListing(file, excludes);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private static List<File> getFileListing(File aStartingDir, Set<String> excludes) throws Exception {
        List<File> result = DirectoryScanner.getFileListingNoSort(aStartingDir, excludes);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir, Set<String> excludes) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isFile()) {
                String extension = null;
                if (file.getName().lastIndexOf(".") != -1) {
                    extension = file.getName().substring(file.getName().lastIndexOf("."));
                }
                if (extension == null || !archives.contains(extension)) continue;
                boolean include = true;
                if (excludes != null) {
                    Iterator<String> it = excludes.iterator();
                    while (include && it.hasNext()) {
                        String exclude = it.next();
                        if (!file.getName().equals(exclude) && file.getAbsolutePath().indexOf(exclude) == -1) continue;
                        include = false;
                    }
                }
                if (!include) continue;
                result.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            List<File> deeperList = DirectoryScanner.getFileListingNoSort(file, excludes);
            result.addAll(deeperList);
        }
        return result;
    }

    static {
        archives.add(".jar");
        archives.add(".war");
    }
}

