/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Extractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(JarFile jarFile) throws IOException {
        File target;
        String basedir = new File(System.getProperty("java.io.tmpdir")).getCanonicalPath();
        String fileName = new File(jarFile.getName()).getCanonicalPath();
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.US).contains("windows");
        if (fileName.startsWith(basedir)) {
            target = isWindows ? new File(fileName + "_") : new File(fileName);
        } else {
            if (fileName.indexOf(":") != -1 && isWindows) {
                fileName = fileName.substring(fileName.indexOf(":") + 1);
            }
            target = new File(basedir, fileName);
        }
        if (target.exists()) {
            Extractor.recursiveDelete(target);
        }
        if (!target.mkdirs()) {
            throw new IOException("Could not create " + target);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            File copy = new File(target, je.getName());
            if (!je.isDirectory()) {
                BufferedInputStream in = null;
                OutputStream out = null;
                if (copy.getParentFile() != null && !copy.getParentFile().exists() && !copy.getParentFile().mkdirs()) {
                    throw new IOException("Could not create " + copy.getParentFile());
                }
                try {
                    int nBytes;
                    in = new BufferedInputStream(jarFile.getInputStream(je));
                    out = new BufferedOutputStream(new FileOutputStream(copy));
                    byte[] buffer = new byte[4096];
                    while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                        out.write(buffer, 0, nBytes);
                    }
                    out.flush();
                    continue;
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (in == null) continue;
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            if (!copy.exists()) {
                if (copy.mkdirs()) continue;
                throw new IOException("Could not create " + copy);
            }
            if (copy.isDirectory()) continue;
            throw new IOException(copy + " isn't a directory");
        }
        return target;
    }

    private static void recursiveDelete(File file) throws IOException {
        if (file != null && file.exists()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Extractor.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete the file of: " + files[i]);
                }
            }
            if (!file.delete()) {
                throw new IOException("Could not delete the file of: " + file);
            }
        }
    }
}

