/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.jboss.tattletale.analyzers.AbstractScanner;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.JarArchive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.profiles.Profile;

public class JarScanner
extends AbstractScanner {
    @Override
    public Archive scan(File file) {
        return this.scan(file, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Archive scan(File file, Map<String, SortedSet<String>> gProvides, List<Profile> known, Set<String> blacklisted) {
        JarArchive archive = null;
        ZipFile jarFile = null;
        String name = file.getName();
        try {
            JarEntry jarEntry;
            String canonicalPath = file.getCanonicalPath();
            jarFile = new JarFile(file);
            Integer classVersion = null;
            TreeSet<String> requires = new TreeSet<String>();
            TreeMap<String, Long> provides = new TreeMap<String, Long>();
            TreeSet<String> profiles = new TreeSet<String>();
            TreeMap<String, SortedSet<String>> classDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> packageDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> blacklistedDependencies = new TreeMap<String, SortedSet<String>>();
            ArrayList<String> lSign = null;
            Enumeration<JarEntry> jarEntries = ((JarFile)jarFile).entries();
            while (jarEntries.hasMoreElements()) {
                jarEntry = jarEntries.nextElement();
                String entryName = jarEntry.getName();
                InputStream entryStream = null;
                if (entryName.endsWith(".class")) {
                    try {
                        entryStream = ((JarFile)jarFile).getInputStream(jarEntry);
                        classVersion = this.scanClasses(entryStream, blacklisted, known, classVersion, provides, requires, profiles, classDependencies, packageDependencies, blacklistedDependencies);
                        continue;
                    }
                    catch (Exception ie) {
                        System.err.println("Error happened while scanning following class:");
                        System.err.println(jarFile.getName() + ":" + jarEntry.getName());
                        ie.printStackTrace();
                        System.err.println("Continue to generate the rest of report, please wait ... ");
                        continue;
                    }
                    finally {
                        if (entryStream != null) {
                            entryStream.close();
                        }
                        continue;
                    }
                }
                if (!entryName.contains("META-INF") || !entryName.endsWith(".SF")) continue;
                InputStream is = null;
                try {
                    is = ((JarFile)jarFile).getInputStream(jarEntry);
                    InputStreamReader isr = new InputStreamReader(is);
                    LineNumberReader lnr = new LineNumberReader(isr);
                    if (lSign == null) {
                        lSign = new ArrayList<String>();
                    }
                    String s = lnr.readLine();
                    while (s != null) {
                        lSign.add(s);
                        s = lnr.readLine();
                    }
                }
                catch (Exception isr) {}
                continue;
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (IOException isr) {}
                }
            }
            if (provides.size() == 0) {
                jarEntry = null;
                return jarEntry;
            }
            String version = null;
            List<String> lManifest = null;
            Manifest manifest = ((JarFile)jarFile).getManifest();
            if (manifest != null) {
                version = this.versionFromManifest(manifest);
                lManifest = this.readManifest(manifest);
            }
            Location location = new Location(canonicalPath, version);
            if (classVersion == null) {
                classVersion = 0;
            }
            archive = new JarArchive(name, classVersion, lManifest, lSign, requires, provides, classDependencies, packageDependencies, blacklistedDependencies, location);
            this.addProfilesToArchive(archive, profiles);
            for (String provide : provides.keySet()) {
                if (gProvides != null) {
                    SortedSet<String> ss = gProvides.get(provide);
                    if (ss == null) {
                        ss = new TreeSet<String>();
                    }
                    ss.add(archive.getName());
                    gProvides.put(provide, ss);
                }
                requires.remove(provide);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Scan: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException ioe) {}
        }
        return archive;
    }
}

