/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.core;

import java.io.Serializable;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Location;

public abstract class Archive
implements Serializable,
Comparable {
    static final long serialVersionUID = 8349128019949046037L;
    private int type;
    private String name;
    private int version;
    private List<String> manifest;
    private List<String> sign;
    private SortedSet<String> requires;
    private SortedMap<String, Long> provides;
    private SortedSet<String> profiles;
    private SortedMap<String, SortedSet<String>> classDependencies;
    private SortedMap<String, SortedSet<String>> packageDependencies;
    private SortedMap<String, SortedSet<String>> blacklistedDependencies;
    private SortedSet<Location> locations;
    private transient Boolean osgi;
    private String moduleIdentifier;
    private Archive parentArchive = null;

    public Archive(int type, String name, int version, List<String> manifest, List<String> sign, SortedSet<String> requires, SortedMap<String, Long> provides, SortedMap<String, SortedSet<String>> classDependencies, SortedMap<String, SortedSet<String>> packageDependencies, SortedMap<String, SortedSet<String>> blacklistedDependencies, Location location) {
        this.type = type;
        this.name = name;
        this.version = version;
        this.manifest = manifest;
        this.sign = sign;
        this.requires = requires;
        this.provides = provides;
        this.profiles = new TreeSet<String>();
        this.classDependencies = classDependencies;
        this.packageDependencies = packageDependencies;
        this.blacklistedDependencies = blacklistedDependencies;
        this.locations = new TreeSet<Location>();
        this.osgi = null;
        this.moduleIdentifier = name;
        if (location != null) {
            this.locations.add(location);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public List<String> getManifest() {
        return this.manifest;
    }

    public boolean hasManifestKey(String key) {
        if (this.manifest != null) {
            for (String s : this.manifest) {
                if (!s.startsWith(key)) continue;
                return true;
            }
        }
        return false;
    }

    public String getManifestValue(String key) {
        if (this.manifest != null) {
            StringBuffer value = new StringBuffer();
            boolean found = false;
            for (String s : this.manifest) {
                int idx;
                if (s.startsWith(key)) {
                    idx = s.indexOf(":");
                    value = value.append(s.substring(idx + 1).trim());
                    found = true;
                    continue;
                }
                if (!found) continue;
                idx = s.indexOf(":");
                if (idx != -1) {
                    return value.toString().trim();
                }
                value = value.append(s.trim());
            }
        }
        return null;
    }

    public List<String> getSign() {
        return this.sign;
    }

    public SortedSet<String> getRequires() {
        return this.requires;
    }

    public SortedMap<String, Long> getProvides() {
        return this.provides;
    }

    public SortedSet<String> getProfiles() {
        return this.profiles;
    }

    public void addProfile(String profile) {
        this.profiles.add(profile);
    }

    public SortedMap<String, SortedSet<String>> getClassDependencies() {
        return this.classDependencies;
    }

    public SortedMap<String, SortedSet<String>> getPackageDependencies() {
        return this.packageDependencies;
    }

    public SortedMap<String, SortedSet<String>> getBlackListedDependencies() {
        return this.blacklistedDependencies;
    }

    public SortedSet<Location> getLocations() {
        return this.locations;
    }

    public void addLocation(Location value) {
        this.locations.add(value);
    }

    public boolean doesProvide(String clz) {
        return this.provides.containsKey(clz);
    }

    public boolean isOSGi() {
        if (this.osgi == null) {
            this.initOSGi();
        }
        return this.osgi;
    }

    public void setModuleIdentifier(String moduleIdentifier) {
        this.moduleIdentifier = moduleIdentifier;
    }

    public String getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    private void initOSGi() {
        this.osgi = this.hasManifestKey("Bundle-SymbolicName");
    }

    public int compareTo(Object o) {
        Archive a = (Archive)o;
        return this.name.compareTo(a.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Archive)) {
            return false;
        }
        Archive a = (Archive)obj;
        return this.name.equals(a.getName());
    }

    public int hashCode() {
        return 7 + 31 * this.name.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb = sb.append(this.getClass().getName());
        sb = sb.append("(\n");
        sb = sb.append("type=");
        sb = sb.append(this.type);
        sb = sb.append("\n");
        sb = sb.append("name=");
        sb = sb.append(this.name);
        sb = sb.append("\n");
        sb = sb.append("version=");
        sb = sb.append(this.version);
        sb = sb.append("\n");
        sb = sb.append("manifest=");
        sb = sb.append(this.manifest);
        sb = sb.append("\n");
        sb = sb.append("sign=");
        sb = sb.append(this.sign);
        sb = sb.append("\n");
        sb = sb.append("requires=");
        sb = sb.append(this.requires);
        sb = sb.append("\n");
        sb = sb.append("provides=");
        sb = sb.append(this.provides);
        sb = sb.append("\n");
        sb = sb.append("profiles=");
        sb = sb.append(this.profiles);
        sb = sb.append("\n");
        sb = sb.append("classdependencies=");
        sb = sb.append(this.classDependencies);
        sb = sb.append("\n");
        sb = sb.append("packagedependencies=");
        sb = sb.append(this.packageDependencies);
        sb = sb.append("\n");
        sb = sb.append("blacklisteddependencies=");
        sb = sb.append(this.blacklistedDependencies);
        sb = sb.append("\n");
        sb = sb.append("locations=");
        sb = sb.append(this.locations);
        sb = sb.append("\n");
        sb = sb.append(")");
        return sb.toString();
    }

    public Archive getParentArchive() {
        return this.parentArchive;
    }

    public void setParentArchive(Archive parentArchive) {
        this.parentArchive = parentArchive;
    }
}

