/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyValueFilter;
import org.jboss.tattletale.reporting.Report;

public abstract class AbstractReport
implements Report {
    private String id;
    protected int severity;
    protected int status;
    protected SortedSet<Archive> archives;
    private String name = null;
    private String directory = null;
    private File outputDirectory;
    private String filter;
    private Filter filterImpl;
    protected static final String INDEX_HTML = "index.html";

    public AbstractReport(String id, int severity) {
        this.id = id;
        this.severity = severity;
        this.status = 0;
        this.filter = null;
        this.filterImpl = null;
    }

    public AbstractReport(String id, int severity, String name, String directory) {
        this(id, severity);
        this.name = name;
        this.directory = directory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
        this.filterImpl = this.createFilter();
        this.filterImpl.init(filter);
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public String getIndexName() {
        return INDEX_HTML;
    }

    @Override
    public void generate(String outputDirectory) {
        try {
            this.createOutputDir(outputDirectory);
            BufferedWriter bw = this.getBufferedWriter();
            this.writeHtmlHead(bw);
            this.writeHtmlBodyHeader(bw);
            this.writeHtmlBodyContent(bw);
            this.writeHtmlBodyFooter(bw);
            this.writeHtmlFooter(bw);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.err.println(this.getName() + " Report: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    void createOutputDir(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory, this.getDirectory());
        this.outputDirectory.mkdirs();
    }

    BufferedWriter getBufferedWriter() throws IOException {
        return this.getBufferedWriter(INDEX_HTML);
    }

    public BufferedWriter getBufferedWriter(String filename) throws IOException {
        FileWriter fw = new FileWriter(this.getOutputDirectory().getAbsolutePath() + File.separator + filename);
        return new BufferedWriter(fw, 8192);
    }

    public void setArchives(SortedSet<Archive> archives) {
        this.archives = archives;
    }

    public void writeHtmlHead(BufferedWriter bw) throws IOException {
        bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + Dump.newLine());
        bw.write("<html>" + Dump.newLine());
        bw.write("<head>" + Dump.newLine());
        bw.write("  <title>JBoss Tattletale (1.3 - EAP 7): " + this.getName() + "</title>" + Dump.newLine());
        bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + Dump.newLine());
        bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"../style.css\">" + Dump.newLine());
        bw.write("</head>" + Dump.newLine());
    }

    public abstract void writeHtmlBodyHeader(BufferedWriter var1) throws IOException;

    public abstract void writeHtmlBodyContent(BufferedWriter var1) throws IOException;

    public void writeHtmlBodyFooter(BufferedWriter bw) throws IOException {
        bw.write(Dump.newLine());
        bw.write("<p/>" + Dump.newLine());
        bw.write("<hr/>" + Dump.newLine());
        bw.write("Generated by: <a href=\"https://github.com/Maarc/tattletale-eap7\">JBoss Tattletale (1.3 - EAP 7)</a>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("</body>" + Dump.newLine());
    }

    public void writeHtmlFooter(BufferedWriter bw) throws IOException {
        bw.write("</html>" + Dump.newLine());
    }

    public int compareTo(Object o) {
        AbstractReport r = (AbstractReport)o;
        if (this.severity == r.getSeverity()) {
            return this.getName().compareTo(r.getName());
        }
        if (this.severity < r.getSeverity()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Report)) {
            return false;
        }
        AbstractReport r = (AbstractReport)obj;
        return this.getName().equals(r.getName());
    }

    public int hashCode() {
        return 7 + 31 * this.getName().hashCode();
    }

    protected Filter createFilter() {
        return new KeyValueFilter();
    }

    protected boolean isFiltered() {
        if (this.filterImpl != null) {
            return this.filterImpl.isFiltered();
        }
        return false;
    }

    protected boolean isFiltered(String archive) {
        if (this.filterImpl != null) {
            return this.filterImpl.isFiltered(archive);
        }
        return false;
    }

    protected boolean isFiltered(String archive, String query) {
        if (this.filterImpl != null) {
            return this.filterImpl.isFiltered(archive, query);
        }
        return false;
    }
}

