/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

public class MultipleLocationsReport
extends AbstractReport {
    private static final String NAME = "Multiple Locations";
    private static final String DIRECTORY = "multiplelocations";

    public MultipleLocationsReport() {
        super(DIRECTORY, 1, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Name</th>" + Dump.newLine());
        bw.write("     <th>Location</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        this.recursivelyWriteContent(bw, this.archives);
        bw.write("</table>" + Dump.newLine());
    }

    private void recursivelyWriteContent(BufferedWriter bw, Collection<Archive> archives) throws IOException {
        boolean odd = true;
        for (Archive a : archives) {
            if (a instanceof NestableArchive) {
                NestableArchive nestableArchive = (NestableArchive)a;
                this.recursivelyWriteContent(bw, nestableArchive.getSubArchives());
                continue;
            }
            if (a.getLocations().size() <= 1) continue;
            boolean filtered = this.isFiltered(a.getName());
            if (!filtered) {
                this.status = 1;
            }
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../jar/" + a.getName() + ".html\">" + a.getName() + "</a></td>" + Dump.newLine());
            if (!filtered) {
                bw.write("     <td>");
            } else {
                bw.write("     <td style=\"text-decoration: line-through;\">");
            }
            Iterator lit = a.getLocations().iterator();
            while (lit.hasNext()) {
                Location location = (Location)lit.next();
                bw.write(location.getFilename());
                if (!lit.hasNext()) continue;
                bw.write("<br>");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Multiple Locations</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

