/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.BooleanFilter;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;

public class SignReport
extends AbstractReport {
    private static final String NAME = "Signing information";
    private static final String DIRECTORY = "sign";

    public SignReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Status</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        int signed = 0;
        int unsigned = 0;
        for (Archive archive : this.archives) {
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archive.getName() + "</a></td>" + Dump.newLine());
            if (archive.getSign() != null) {
                bw.write("     <td style=\"color: red;\">Signed</td>" + Dump.newLine());
                ++signed;
            } else {
                bw.write("     <td style=\"color: green;\">Unsigned</td>" + Dump.newLine());
                ++unsigned;
            }
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
        boolean filtered = this.isFiltered();
        if (signed > 0 && unsigned > 0 && !filtered) {
            this.status = 1;
        }
        bw.write(Dump.newLine());
        bw.write("<p>" + Dump.newLine());
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Status</th>" + Dump.newLine());
        bw.write("     <th>Archives</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Signed</td>" + Dump.newLine());
        if (!filtered) {
            bw.write("     <td style=\"color: red;\">" + signed + "</td>" + Dump.newLine());
        } else {
            bw.write("     <td style=\"color: red; text-decoration: line-through;\">" + signed + "</td>" + Dump.newLine());
        }
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Unsigned</td>" + Dump.newLine());
        if (!filtered) {
            bw.write("     <td style=\"color: green;\">" + unsigned + "</td>" + Dump.newLine());
        } else {
            bw.write("     <td style=\"color: green; text-decoration: line-through;\">" + unsigned + "</td>" + Dump.newLine());
        }
        bw.write("  </tr>" + Dump.newLine());
        bw.write("</table>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Signing information</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new BooleanFilter();
    }
}

