/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.tools.as7;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.tattletale.tools.as7.ModuleXml;

public class Main {
    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            OutputStreamWriter fw = null;
            try {
                File root = new File(args[0], "modules");
                File outputFile = new File(args[1]);
                fw = new FileWriter(outputFile);
                List<File> jars = Main.getFileListing(root);
                for (File f : jars) {
                    String moduleId = "";
                    String archiveName = f.getName();
                    File moduleXml = new File(f.getParentFile(), "module.xml");
                    if (moduleXml.exists()) {
                        moduleId = ModuleXml.getModuleId(moduleXml);
                    }
                    JarFile jf = new JarFile(f);
                    Enumeration<JarEntry> e = jf.entries();
                    while (e.hasMoreElements()) {
                        JarEntry je = e.nextElement();
                        if (!je.getName().endsWith(".class")) continue;
                        String className = je.getName().replace('/', '.');
                        className = className.substring(0, className.indexOf(".class"));
                        fw.write(className + "," + archiveName + "," + moduleId + "\n");
                    }
                    jf.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException root) {}
                }
            }
        } else {
            System.out.println("Usage: Main <as7> <file>");
        }
    }

    private static List<File> getFileListing(File aStartingDir) throws Exception {
        List<File> result = Main.getFileListingNoSort(aStartingDir);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isFile()) {
                String extension = null;
                if (file.getName().lastIndexOf(".") != -1) {
                    extension = file.getName().substring(file.getName().lastIndexOf("."));
                }
                if (extension == null || !".jar".equals(extension)) continue;
                result.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            List<File> deeperList = Main.getFileListingNoSort(file);
            result.addAll(deeperList);
        }
        return result;
    }
}

