/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.jboss.windup.web.services.model.Category;
import org.jboss.windup.web.services.model.FilterApplication;
import org.jboss.windup.web.services.model.Tag;
import org.jboss.windup.web.services.model.WindupExecution;

@Entity
public class ReportFilter
implements Serializable {
    public static final String REPORT_FILTER_ID = "report_filter_id";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="report_filter_id", updatable=false, nullable=false)
    private Long id;
    @OneToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    private Set<FilterApplication> selectedApplications = new HashSet<FilterApplication>();
    @OneToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinTable(name="report_filter_include_tags")
    private Set<Tag> includeTags = new HashSet<Tag>();
    @OneToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinTable(name="report_filter_exclude_tags")
    private Set<Tag> excludeTags = new HashSet<Tag>();
    @OneToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinTable(name="report_filter_include_categories")
    private Set<Category> includeCategories = new HashSet<Category>();
    @OneToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinTable(name="report_filter_exclude_categories")
    private Set<Category> excludeCategories = new HashSet<Category>();
    @OneToOne(optional=false)
    @JsonIgnore
    private WindupExecution windupExecution;
    @Column(nullable=false)
    private boolean isEnabled = false;

    public ReportFilter() {
    }

    public ReportFilter(WindupExecution execution) {
        this();
        this.windupExecution = execution;
    }

    public Long getId() {
        return this.id;
    }

    public Set<Tag> getIncludeTags() {
        return this.includeTags;
    }

    public void addIncludeTag(Tag tag) {
        this.includeTags.add(tag);
    }

    public void removeIncludeTag(Tag tag) {
        this.includeTags.remove(tag);
    }

    public void clearIncludeTags() {
        this.includeTags.clear();
    }

    public Set<Category> getIncludeCategories() {
        return this.includeCategories;
    }

    public void addIncludeCategory(Category category) {
        this.includeCategories.add(category);
    }

    public void removeIncludeCategory(Category category) {
        this.includeCategories.remove(category);
    }

    public void clearIncludeCategories() {
        this.includeCategories.clear();
    }

    public Set<Category> getExcludeCategories() {
        return this.excludeCategories;
    }

    public void addExcludeCategory(Category ExcludeCategory) {
        this.excludeCategories.add(ExcludeCategory);
    }

    public void removeExcludeCategory(Category ExcludeCategory) {
        this.excludeCategories.remove(ExcludeCategory);
    }

    public void clearExcludeCategories() {
        this.excludeCategories.clear();
    }

    public Set<Tag> getExcludeTags() {
        return this.excludeTags;
    }

    public void addExcludeTag(Tag excludeTag) {
        this.excludeTags.add(excludeTag);
    }

    public void removeExcludeTag(Tag excludeTag) {
        this.excludeTags.remove(excludeTag);
    }

    public void clearExcludeTags() {
        this.excludeTags.clear();
    }

    public WindupExecution getWindupExecution() {
        return this.windupExecution;
    }

    public void setWindupExecution(WindupExecution windupExecution) {
        this.windupExecution = windupExecution;
    }

    public Set<FilterApplication> getSelectedApplications() {
        return this.selectedApplications;
    }

    public void addSelectedApplication(FilterApplication Application) {
        this.selectedApplications.add(Application);
    }

    public void removeSelectedApplication(FilterApplication Application) {
        this.selectedApplications.remove(Application);
    }

    public void clearSelectedApplications() {
        this.selectedApplications.clear();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void clear() {
        this.clearIncludeCategories();
        this.clearExcludeCategories();
        this.clearIncludeTags();
        this.clearExcludeTags();
        this.clearSelectedApplications();
        this.isEnabled = false;
    }
}

